// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _Bisector_Bisec_HeaderFile
#define _Bisector_Bisec_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Handle_Geom2d_TrimmedCurve_HeaderFile
#include <Handle_Geom2d_TrimmedCurve.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom2d_Point_HeaderFile
#include <Handle_Geom2d_Point.hxx>
#endif
class Geom2d_TrimmedCurve;
class Geom2d_Curve;
class gp_Pnt2d;
class gp_Vec2d;
class Geom2d_Point;


//! Bisec  provides the bisecting line between two  elements <br>
//!  This line is trimed by a point <P> and it's contained in the domain <br>
//!  defined by the two vectors <V1>, <V2> and <Sense>. <br>
//! <br>
//!  Definition of  the domain: <br>
//!  if <Sense>  is  true the bisecting line is contained in the sector <br>
//!  defined by <-V1> and <-V2> in the sense indirect. <br>
//!  if <Sense>  is  false the bisecting line is contained in the sector <br>
//!  defined by <-V1> and <-V2> in the sense direct. <br>
class Bisector_Bisec  {
public:

  void* operator new(size_t,void* anAddress) 
  {
    return anAddress;
  }
  void* operator new(size_t size) 
  {
    return Standard::Allocate(size); 
  }
  void  operator delete(void *anAddress) 
  {
    if (anAddress) Standard::Free((Standard_Address&)anAddress); 
  }

  
  Standard_EXPORT   Bisector_Bisec();
  //! Performs  the bisecting line  between the  curves <br>
//!            <Cu1> and <Cu2>. <br>
//!            <oncurve> is True if the point <P> is common to <Cu1> <br>
//!            and <Cu2>. <br>
  Standard_EXPORT     void Perform(const Handle(Geom2d_Curve)& Cu1,const Handle(Geom2d_Curve)& Cu2,const gp_Pnt2d& P,const gp_Vec2d& V1,const gp_Vec2d& V2,const Standard_Real Sense,const Standard_Real Tolerance,const Standard_Boolean oncurve = Standard_True) ;
  //! Performs  the bisecting line  between the  curve <br>
//!            <Cu1> and the point <Pnt>. <br>
//!            <oncurve> is True if the point <P> is the point <Pnt>. <br>
  Standard_EXPORT     void Perform(const Handle(Geom2d_Curve)& Cu,const Handle(Geom2d_Point)& Pnt,const gp_Pnt2d& P,const gp_Vec2d& V1,const gp_Vec2d& V2,const Standard_Real Sense,const Standard_Real Tolerance,const Standard_Boolean oncurve = Standard_True) ;
  //! Performs  the bisecting line  between the  curve <br>
//!            <Cu> and the point <Pnt>. <br>
//!            <oncurve> is True if the point <P> is the point <Pnt>. <br>
  Standard_EXPORT     void Perform(const Handle(Geom2d_Point)& Pnt,const Handle(Geom2d_Curve)& Cu,const gp_Pnt2d& P,const gp_Vec2d& V1,const gp_Vec2d& V2,const Standard_Real Sense,const Standard_Real Tolerance,const Standard_Boolean oncurve = Standard_True) ;
  //! Performs  the bisecting line  between the two points <br>
//!            <Pnt1>  and <Pnt2>. <br>
  Standard_EXPORT     void Perform(const Handle(Geom2d_Point)& Pnt1,const Handle(Geom2d_Point)& Pnt2,const gp_Pnt2d& P,const gp_Vec2d& V1,const gp_Vec2d& V2,const Standard_Real Sense,const Standard_Real Tolerance = 0.0,const Standard_Boolean oncurve = Standard_True) ;
  //! Returns the Curve of <me>. <br>
  Standard_EXPORT    const Handle_Geom2d_TrimmedCurve& Value() const;
  //! Returns the Curve of <me>. <br>
//! <br>
  Standard_EXPORT    const Handle_Geom2d_TrimmedCurve& ChangeValue() ;





protected:





private:



Handle_Geom2d_TrimmedCurve thebisector;


};





// other Inline functions and methods (like "C++: function call" methods)


#endif
