// This file is generated by WOK (CPPExt).
// Please do not edit this file; modify original file instead.
// The copyright and license terms as defined for the original file apply to 
// this header file considered to be the "object code" form of the original source.

#ifndef _GeomFill_Pipe_HeaderFile
#define _GeomFill_Pipe_HeaderFile

#ifndef _Standard_HeaderFile
#include <Standard.hxx>
#endif
#ifndef _Standard_DefineAlloc_HeaderFile
#include <Standard_DefineAlloc.hxx>
#endif
#ifndef _Standard_Macro_HeaderFile
#include <Standard_Macro.hxx>
#endif

#ifndef _Standard_Real_HeaderFile
#include <Standard_Real.hxx>
#endif
#ifndef _Handle_Adaptor3d_HCurve_HeaderFile
#include <Handle_Adaptor3d_HCurve.hxx>
#endif
#ifndef _Handle_Geom_Surface_HeaderFile
#include <Handle_Geom_Surface.hxx>
#endif
#ifndef _Handle_GeomFill_LocationLaw_HeaderFile
#include <Handle_GeomFill_LocationLaw.hxx>
#endif
#ifndef _Handle_GeomFill_SectionLaw_HeaderFile
#include <Handle_GeomFill_SectionLaw.hxx>
#endif
#ifndef _Standard_Integer_HeaderFile
#include <Standard_Integer.hxx>
#endif
#ifndef _Standard_Boolean_HeaderFile
#include <Standard_Boolean.hxx>
#endif
#ifndef _Handle_Geom_Curve_HeaderFile
#include <Handle_Geom_Curve.hxx>
#endif
#ifndef _GeomFill_Trihedron_HeaderFile
#include <GeomFill_Trihedron.hxx>
#endif
#ifndef _Handle_Geom2d_Curve_HeaderFile
#include <Handle_Geom2d_Curve.hxx>
#endif
#ifndef _GeomAbs_Shape_HeaderFile
#include <GeomAbs_Shape.hxx>
#endif
class Adaptor3d_HCurve;
class Geom_Surface;
class GeomFill_LocationLaw;
class GeomFill_SectionLaw;
class Standard_ConstructionError;
class Geom_Curve;
class Geom2d_Curve;
class gp_Dir;
class TColGeom_SequenceOfCurve;


//! Describes functions to construct pipes. A pipe is built by <br>
//! sweeping a curve (the section) along another curve (the path). <br>
//! The Pipe class provides the following types of construction: <br>
//! -   pipes with a circular section of constant radius, <br>
//! -   pipes with a constant section, <br>
//! -   pipes with a section evolving between two given curves. <br>
//!   All standard specific cases are detected in order to build, <br>
//! where required, a plane, cylinder, cone, sphere, torus, <br>
//! surface of linear extrusion or surface of revolution. <br>
//! Generally speaking, the result is a BSpline surface (NURBS). <br>
//! A Pipe object provides a framework for: <br>
//! -   defining the pipe to be built, <br>
//! -   implementing the construction algorithm, and <br>
//! -   consulting the resulting surface. <br>
//!          There are several methods to instantiate a Pipe: <br>
//!          1) give a path and  a radius : the section is <br>
//!          a circle.  This location  is the first  point <br>
//!          of the path,  and this direction is the first <br>
//!          derivate (calculate at  the  first point ) of <br>
//!          the path. <br>
//! <br>
//!          2) give a path and a section. <br>
//!             Differtent options are available <br>
//!          2.a) Use the classical Frenet trihedron <br>
//!            - or the CorrectedFrenet trihedron <br>
//!              (To avoid twisted surface) <br>
//!            - or a constant trihedron to have all the sections <br>
//!              in a same plane <br>
//!          2.b) Define a ConstantBinormal Direction to keep the <br>
//!            same angle beetween the Direction and the sections <br>
//!            along the sweep surface. <br>
//!          2.c) Define the path by a surface and a 2dcurve, <br>
//!            the surface is used to define the trihedron's normal. <br>
//!            It is usefull to keep a constant angle beetween <br>
//!            input surface and the pipe.                           -- <br>
//!          3) give a  path and two sections. The section <br>
//!          evoluate from First to Last Section. <br>
//! <br>
//!          3) give a  path and N sections. The section <br>
//!          evoluate from First to Last Section. <br>
//! <br>
//!          In general case the result is a NURBS. But we <br>
//!          can  generate plane,  cylindrical, spherical, <br>
//!          conical, toroidal surface in some particular case. <br>
//! <br>
//!          The natural parametrization of the result is: <br>
//! <br>
//!             U-Direction along the section. <br>
//!             V-Direction along the path. <br>
//! <br>
//!          But, in some particular case, the surface must <br>
//!          be construct otherwise. <br>
//!          The method "EchangeUV" return false in such cases. <br>
//! <br>
class GeomFill_Pipe  {
public:

  DEFINE_STANDARD_ALLOC

  
//! Constructs an empty algorithm for building pipes. Use <br>
//! the function Init to initialize it. <br>
  Standard_EXPORT   GeomFill_Pipe();
  
  Standard_EXPORT   GeomFill_Pipe(const Handle(Geom_Curve)& Path,const Standard_Real Radius);
  //!  Create  a  pipe  with  a  constant  section <br>
//!  (<FirstSection>)  and a path (<Path>) <br>
//! Option can be  - GeomFill_IsCorrectedFrenet <br>
//!                - GeomFill_IsFrenet <br>
//!                - GeomFill_IsConstant <br>
  Standard_EXPORT   GeomFill_Pipe(const Handle(Geom_Curve)& Path,const Handle(Geom_Curve)& FirstSect,const GeomFill_Trihedron Option = GeomFill_IsCorrectedFrenet);
  //!  Create  a  pipe  with  a  constant  section <br>
//!  (<FirstSection>)  and a path defined by <Path> and <Support> <br>
  Standard_EXPORT   GeomFill_Pipe(const Handle(Geom2d_Curve)& Path,const Handle(Geom_Surface)& Support,const Handle(Geom_Curve)& FirstSect);
  //!  Create  a  pipe with  a  constant section <br>
//!    (<FirstSection>) and a   path <Path>  and a fixed <br>
//!    binormal direction <Dir> <br>
  Standard_EXPORT   GeomFill_Pipe(const Handle(Geom_Curve)& Path,const Handle(Geom_Curve)& FirstSect,const gp_Dir& Dir);
  //! Create a pipe with an evolving section <br>
//!          The section evoluate from First to Last Section <br>
  Standard_EXPORT   GeomFill_Pipe(const Handle(Geom_Curve)& Path,const Handle(Geom_Curve)& FirstSect,const Handle(Geom_Curve)& LastSect);
  //! Create a pipe with N  sections <br>
//!          The section evoluate from First to Last Section <br>
  Standard_EXPORT   GeomFill_Pipe(const Handle(Geom_Curve)& Path,const TColGeom_SequenceOfCurve& NSections);
  //! Create  a pipe  with  a constant  radius with  2 <br>
//!          guide-line. <br>
  Standard_EXPORT   GeomFill_Pipe(const Handle(Geom_Curve)& Path,const Handle(Geom_Curve)& Curve1,const Handle(Geom_Curve)& Curve2,const Standard_Real Radius);
  //! Create  a pipe  with  a constant  radius with  2 <br>
//!          guide-line. <br>
  Standard_EXPORT   GeomFill_Pipe(const Handle(Adaptor3d_HCurve)& Path,const Handle(Adaptor3d_HCurve)& Curve1,const Handle(Adaptor3d_HCurve)& Curve2,const Standard_Real Radius);
  //! Create a pipe with a constant section and  with 1 <br>
//!          guide-line. <br>
//!     Use the function Perform to build the surface. <br>
//! All standard specific cases are detected in order to <br>
//! construct, according to the respective geometric <br>
//! nature of Path and the sections, a planar, cylindrical, <br>
//! conical, spherical or toroidal surface, a surface of <br>
//! linear extrusion or a surface of revolution. <br>
//! In the general case, the result is a BSpline surface <br>
//! (NURBS) built by approximation of a series of sections where: <br>
//! -   the number of sections N is chosen automatically <br>
//!   by the algorithm according to the respective <br>
//!   geometries of Path and the sections. N is greater than or equal to 2; <br>
//! -   N points Pi (with i in the range [ 1,N ]) are <br>
//!   defined at regular intervals along the curve Path <br>
//!   from its first point to its end point. At each point Pi, <br>
//!   a coordinate system Ti is computed with Pi as <br>
//!   origin, and with the tangential and normal vectors <br>
//!   to Path defining two of its coordinate axes. <br>
//! In the case of a pipe with a constant circular section, <br>
//! the first section is a circle of radius Radius centered <br>
//! on the origin of Path and whose "Z Axis" is aligned <br>
//! along the vector tangential to the origin of Path. In the <br>
//! case of a pipe with a constant section, the first section <br>
//! is the curve FirstSect. In these two cases, the ith <br>
//! section (for values of i greater than 1) is obtained by <br>
//! applying to a copy of this first section the geometric <br>
//! transformation which transforms coordinate system <br>
//! T1 into coordinate system Ti. <br>
//! In the case of an evolving section, N-2 intermediate <br>
//! curves Si are first computed (if N is greater than 2, <br>
//! and with i in the range [ 2,N-1 ]) whose geometry <br>
//! evolves regularly from the curve S1=FirstSect to the <br>
//! curve SN=LastSect. The first section is FirstSect, <br>
//! and the ith section (for values of i greater than 1) is <br>
//! obtained by applying to the curve Si the geometric <br>
//! transformation which transforms coordinate system <br>
//! T1 into coordinate system Ti. <br>
  Standard_EXPORT   GeomFill_Pipe(const Handle(Geom_Curve)& Path,const Handle(Adaptor3d_HCurve)& Guide,const Handle(Geom_Curve)& FirstSect,const Standard_Boolean ByACR,const Standard_Boolean rotat);
  
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& Path,const Standard_Real Radius) ;
  
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& Path,const Handle(Geom_Curve)& FirstSect,const GeomFill_Trihedron Option = GeomFill_IsCorrectedFrenet) ;
  
  Standard_EXPORT     void Init(const Handle(Geom2d_Curve)& Path,const Handle(Geom_Surface)& Support,const Handle(Geom_Curve)& FirstSect) ;
  
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& Path,const Handle(Geom_Curve)& FirstSect,const gp_Dir& Dir) ;
  
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& Path,const Handle(Geom_Curve)& FirstSect,const Handle(Geom_Curve)& LastSect) ;
  
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& Path,const TColGeom_SequenceOfCurve& NSections) ;
  //! Create  a pipe  with  a constant  radius with  2 <br>
//!          guide-line. <br>
  Standard_EXPORT     void Init(const Handle(Adaptor3d_HCurve)& Path,const Handle(Adaptor3d_HCurve)& Curve1,const Handle(Adaptor3d_HCurve)& Curve2,const Standard_Real Radius) ;
  
//! Initializes this pipe algorithm to build the following surface: <br>
//! -   a pipe with a constant circular section of radius <br>
//!   Radius along the path Path, or <br>
//! -   a pipe with constant section FirstSect along the path Path, or <br>
//! -   a pipe where the section evolves from FirstSect to <br>
//!   LastSect along the path Path. <br>
//! Use the function Perform to build the surface. <br>
//! Note: a description of the resulting surface is given under Constructors. <br>
  Standard_EXPORT     void Init(const Handle(Geom_Curve)& Path,const Handle(Adaptor3d_HCurve)& Guide,const Handle(Geom_Curve)& FirstSect,const Standard_Boolean ByACR,const Standard_Boolean rotat) ;
  //! Builds the pipe defined at the time of initialization of this <br>
//! algorithm. A description of the resulting surface is given under Constructors. <br>
//! If WithParameters (defaulted to false) is set to true, the <br>
//! approximation algorithm (used only in the general case <br>
//! of construction of a BSpline surface) builds the surface <br>
//! with a u parameter corresponding to the one of the path. <br>
//! Exceptions <br>
//! Standard_ConstructionError if a surface cannot be constructed from the data. <br>
//!  Warning: It is the old Perform method, the next methode is recommended. <br>
  Standard_EXPORT     void Perform(const Standard_Boolean WithParameters = Standard_False,const Standard_Boolean myPolynomial = Standard_False) ;
  //! detects the  particular cases.  And compute the surface. <br>
//!    if  none   particular  case  is  detected we make an approximation <br>
//!    with respect of the Tolerance <Tol>, the continuty <Conti>, the <br>
//!    maximum degree <MaxDegree>, the maximum number of span <NbMaxSegment> <br>
//!    and the spine parametrization. <br>//! If we can't create a surface with the data <br>
  Standard_EXPORT     void Perform(const Standard_Real Tol,const Standard_Boolean Polynomial,const GeomAbs_Shape Conti = GeomAbs_C1,const Standard_Integer MaxDegree = 11,const Standard_Integer NbMaxSegment = 30) ;
  //! Returns the surface built by this algorithm. <br>
//! Warning <br>
//! Do not use this function before the surface is built (in this <br>
//! case the function will return a null handle). <br>
       const Handle_Geom_Surface& Surface() const;
  //! The u parametric direction of the surface constructed by <br>
//! this algorithm usually corresponds to the evolution <br>
//! along the path and the v parametric direction <br>
//! corresponds to the evolution along the section(s). <br>
//! However, this rule is not respected when constructing <br>
//! certain specific Geom surfaces (typically cylindrical <br>
//! surfaces, surfaces of revolution, etc.) for which the <br>
//! parameterization is inversed. <br>
//! The ExchangeUV function checks for this, and returns <br>
//! true in all these specific cases. <br>
//! Warning <br>
//! Do not use this function before the surface is built. <br>
  Standard_EXPORT     Standard_Boolean ExchangeUV() const;
  //! Sets a flag  to  try to   create as many   planes, <br>
//!          cylinder,...    as  possible.  Default  value   is <br>
//!          <Standard_False>. <br>
        void GenerateParticularCase(const Standard_Boolean B) ;
  //! Returns the flag. <br>
        Standard_Boolean GenerateParticularCase() const;
  //! Returns the approximation's error.  if the Surface <br>
//!          is plane, cylinder ... this error can be 0. <br>
        Standard_Real ErrorOnSurf() const;





protected:





private:

  
  Standard_EXPORT     void Init() ;
  //! The result  (<mySurface>)  is an approximation.  Using <br>
//!          <SweepSectionGenerator>  to      do    that.        If <br>
//!          <WithParameters>    is   set  to <Standard_True>,  the <br>
//!          apprxoximation will be   done in respect to  the spine <br>
//!          parametrization. <br>
  Standard_EXPORT     void ApproxSurf(const Standard_Boolean WithParameters) ;
  
  Standard_EXPORT     Standard_Boolean KPartT4() ;


Standard_Real myRadius;
Standard_Real myError;
Handle_Adaptor3d_HCurve myAdpPath;
Handle_Adaptor3d_HCurve myAdpFirstSect;
Handle_Adaptor3d_HCurve myAdpLastSect;
Handle_Geom_Surface mySurface;
Handle_GeomFill_LocationLaw myLoc;
Handle_GeomFill_SectionLaw mySec;
Standard_Integer myType;
Standard_Boolean myExchUV;
Standard_Boolean myKPart;
Standard_Boolean myPolynomial;


};


#include <GeomFill_Pipe.lxx>



// other Inline functions and methods (like "C++: function call" methods)


#endif
