/* NVTV Gui -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This is open software protected by the GPL. See GPL.txt for details.
 *
 * Header: The GTK graphical user interface.
 */

#ifndef _GUI_H
#define _GUI_H

#include <gtk/gtk.h>
#include "backend.h"
#include "nv_type.h"

/* FIXME: Think about global vars */

extern NVCrtRegs gui_crt;
extern NVTvRegs gui_tv;

extern NVSystem gui_system;
extern NVMode *gui_list_mode;
extern NVMode *gui_act_mode;

extern NVPtr gui_pNv;

extern NVTvChip gui_tv_chip;

typedef GtkAdjustment GuiNotify;

extern GuiNotify *update_crt;
extern GuiNotify *update_chip;
extern GuiNotify *update_mode;
extern GuiNotify *changed_all;

typedef enum {
  ACCEL_FIRST  = 0,
  ACCEL_TV_ON  = 0,
  ACCEL_TV_OFF = 1,
  ACCEL_CENTER = 2,
  ACCEL_RESET  = 3,
  ACCEL_PRINT  = 4,
  ACCEL_LAST   = 5,
} GuiAccelIndex;

typedef struct accel_struct {
  char *label;
  char *accel;
  guint key;
  GdkModifierType mods;
} GuiAccel;

extern GuiAccel gui_accel [ACCEL_LAST];

struct reg_mask {
  char *label;
  int  bits;
  int  tick;
  void *addr;
  int  size;
};

struct flag_mask {
  char *label;
  int  mask;
  void *addr;
  int  size;
};

#define PRINT_CRT_REGS	 (1 << 0)
#define PRINT_CHIP_REGS	 (1 << 1)
#define PRINT_ADJUSTED	 (1 << 2)

GtkWidget* create_option_menu (GtkSignalFunc func, ...);

GtkWidget *create_arrow_button (GtkTable *table, GtkArrowType arrow_type,
  int x0, int x1, int y0, int y1);

GtkWidget *create_radio_box (int active, gboolean hor_vert, 
  GtkSignalFunc func, GSList **group, ...);

GuiNotify *create_notify (void);


void gui_mask_checkbutton (GtkWidget *table, GtkObject *changed, 
  struct flag_mask *m, int x1, int x2, int y);

void gui_mask_entry (GtkWidget *table, GtkObject *changed, 
  struct reg_mask *m, int x1, int x2, int x3, int y);

void gui_mask_twin_entry (GtkWidget *table, GtkObject *changed, 
  struct reg_mask *m, int x1, int x2, int x3, int x4, int y);

void gui_act_mode_set (NVMode *mode);

void gui_tv_set (void);

void gui_map_cb (GtkWidget *widget, GtkAccelGroup *group);
void gui_unmap_cb (GtkWidget *widget, GtkAccelGroup *group);

void gui_print_cb (GtkButton *button, gpointer data);

void gui_main (int argc, char *argv[], CardPtr card_list);

#endif /* _GUI_H */
