/* NVTV data header -- Dirk Thierbach <dthierbach@gmx.de>
 *
 * This file is part of nvtv, a tool for tv-output on NVidia cards.
 * 
 * nvtv is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * nvtv is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA
 *
 * $Id$
 *
 */ 

#ifndef _DATA_H
#define _DATA_H

#include "nv_tvchip.h"

typedef struct {
  NVMode *modes;
  void (*init) (NVSystem system, NVTvRegs *r);
  void (*defaults) (NVSettings *s);
  void (*setup) (NVSettings *s, NVCrtRegs *c, NVTvRegs *r);
  void (*clamp) (NVSettings *s);
} DataFunc;

int data_clamp (int val, int size, int ticks[]);
int data_pick (int val, int size, int ticks[]);

NVMode *data_find (NVMode *modes, NVSystem system, 
  int res_x, int res_y, char *size);

DataFunc *data_func (NVTvChip chip);

#endif /* _DATA_BT_H */
