/*
 * multilingual support for nvi
 * Copyright(c) 1996, 1997 by Jun-ichiro Itoh.  All rights reserved.
 * Author contact: <itojun@mt.cs.keio.ac.jp>
 * $Id: multi_none.c,v 1.1.2.1 1997/09/23 00:43:51 itojun Exp $
 *
 * Freely redistributable, reusable, unless otherwise noted in accompanying
 * document. (for example, redistribution is prohibited during alpha-test
 * period)
 * Absolutely no warranty.
 *
 * The code is based on:
 *	jelvis japanization patch by Jun-ichiro Itoh
 *	nvi 1.03 japanization patch by Yoshitaka Tokugawa <toku@dit.co.jp>
 */

#include "config.h"

#ifdef MULTIBYTE

#include <sys/types.h>
#include <sys/queue.h>

#include <bitstring.h>
#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "../common/common.h"
#include "multibyte.h"

int
none_to_int(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;

	q = dst;
	p = src;
	if (pflags)
		FL_INIT(*pflags, 0);

	for (i = 0; i < slen; i++) {
		if (p[0] & 0x80) {
			if (dst) {
				*q++ = CS_RAW0 + v_key_len(sp, *p);
				*q++ = *p & 0x7f;
				p++;
			} else {
				q += 2;
				p++;
			}
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}

int
int_to_none(sp, e, dst, pdlen, src, slen, pflags, state)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *dst;
	size_t *pdlen;
	CHAR_T *src;
	size_t slen;
	int *pflags;
	ISO2022STATE *state;
{
	CHAR_T *p;
	CHAR_T *q;
	size_t i;

	if (pflags)
		FL_INIT(*pflags, 0);
	q = dst;
	p = src;

	for (i = 0; i < slen; i++) {
		if (CS_RAW(p[0])) {
			if (dst) {
				*q++ = p[1] | 0x80;
				p += 2;
			} else {
				q++;
				p += 2;
			}
			i++;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE);
			continue;
		} else if (p[0] & 0x80) {
			/*
			 * Unknown encoding.  Simply skip them.
			 */
			p += charset(p[0]).blen;
			i += 2;		/*plus one at for loop*/
			if (pflags)
				FL_SET(*pflags, MB_MULTIBYTE|MB_SKIP);
			continue;
		}

		if (dst)
			*q++ = *p++;
		else {
			q++;
			p++;
		}
	}

	if (pdlen)
		*pdlen = q - dst;
	return 0;
}

void
none_keyinput(sp, e, kbuf, kbuflen, intbuf, pintbuflen, pstate, pconsumed)
	SCR *sp;
	ENCODING const *e;
	CHAR_T *kbuf;
	size_t kbuflen;
	CHAR_T *intbuf;
	size_t *pintbuflen;
	int *pstate;
	size_t *pconsumed;
{
	size_t i;
	size_t j;
	size_t consumed;

	i = j = consumed = 0;
	while (i < kbuflen) {
		/*
		 * Non-kanji cases.
		 */
		if (kbuf[i] & 0x80) {
			intbuf[j++] = CS_RAW0 + v_key_len(sp, kbuf[i]);
			intbuf[j++] = kbuf[i] & 0x7f;
			i++;
			*pstate = 0;
			consumed++;
		} else {
			intbuf[j++] = kbuf[i++];
			*pstate = 0;
			consumed++;
		}
	}
	*pintbuflen = j;
	*pconsumed = consumed;
}
#endif /*MULTIBYTE*/
