// file kernel/n/x86-4/shift.S: shift of natural integers
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                                 Dcalages                             |
 |                                                                       |
 +-----------------------------------------------------------------------*/

                           # +---------------------+
                           # |  Dcalage  droite  |
                           # +---------------------+

# entre :
#   a = naturel de longueur l      rsi = &a, rcx = l
#       
# contrainte : l > 0
#
# sortie :
#   a <- a/2
#
# registres modifis :
#   rax <- ind.
#   rcx = 0
#   r8  <- ind.
#   CF  = bit 0 de a

#undef L
#define L(x) .Lsn_fhalf_##x
        
        ALIGN(32)
.Lsn_fhalf:
        
        # calcule l adresse de saut dans la boucle
        leaq   L(loop)(%rip), %r8
        movq   %rcx,    %rax
        negq   %rax
        andq   $15,     %rax            # rax <- (-l) mod 16
        addq   %rax,    %rcx            # rcx <- 16*ceil(l/16)
	leaq   (%rax,%rax,4), %rax      # rax <- 5*reste
        addq   %rax,    %r8
        jmp    *%r8

        # boucle droule 16 fois. Taille d une instruction = 5 octets
        ALIGN(8)
L(loop):
        rcrq   $1,   -8(%rsi,%rcx,8)
        rcrq   $1,  -16(%rsi,%rcx,8)
        rcrq   $1,  -24(%rsi,%rcx,8)
        rcrq   $1,  -32(%rsi,%rcx,8)
        rcrq   $1,  -40(%rsi,%rcx,8)
        rcrq   $1,  -48(%rsi,%rcx,8)
        rcrq   $1,  -56(%rsi,%rcx,8)
        rcrq   $1,  -64(%rsi,%rcx,8)
        rcrq   $1,  -72(%rsi,%rcx,8)
        rcrq   $1,  -80(%rsi,%rcx,8)
        rcrq   $1,  -88(%rsi,%rcx,8)
        rcrq   $1,  -96(%rsi,%rcx,8)
        rcrq   $1, -104(%rsi,%rcx,8)
        rcrq   $1, -112(%rsi,%rcx,8)
        rcrq   $1, -120(%rsi,%rcx,8)
        rcrq   $1, -128(%rsi,%rcx,8)
        leaq   -15(%rcx), %rcx
        loop   L(loop)

        ret


                 # +---------------------------------------+
                 # |  Dcalage par adresses dcroissantes  |
                 # +---------------------------------------+
        
# entre :
#   a = naturel de longueur la     rsi = &a, rdx = la
#   b = naturel de longueur la     rdi = &b
#   k = entier                     rcx = k
# contraintes : la > 0, 0 < k < HW
#
# sortie :
#   b <- a >> k
#
# registres modifis :
#   rax = a[0],  rbx = b[0]
#   rcx = 64-k,  rdx = 0

#ifdef assembly_sn_shift_down
#undef L
#define L(x) .Lsn_fshift_down_##x
        ALIGN(32)
.Lsn_fshift_down:

        subq   $64,     %rcx
        negq   %rcx                     # rcx <- 64-k
        xorq   %rbx,    %rbx            # init retenues
        movq   %rbx,    %rax
        incq   %rdx
        btrq   $0,      %rdx            # si la est impair, ...
        jnc    2f                       # saute en milieu de boucle

        # corps de boucle droule 2 fois
        ALIGN(8)
1:
        movq  -8(%rsi,%rdx,8), %rbx
        shldq  %cl, %rbx, %rax
        movq   %rax, -8(%rdi,%rdx,8)
2:
        movq   -16(%rsi,%rdx,8), %rax
        shldq  %cl, %rax, %rbx
        movq   %rbx, -16(%rdi,%rdx,8)
        subq   $2,  %rdx
        jne    1b
        ret
        
                              # +---------------+
                              # |  Interface C  |
                              # +---------------+
        
# chiffre xn(shift_down)(chiffre *a, long la, chiffre *b, int k)
#
#  entre :
#  a = naturel de longueur la > 0
#  b = naturel de longueur la, peut tre confondu avec a
#  k = entier tel que 0 <= k < HW
#
#  sortie :
#  b <- a >> k
#  retourne a mod 2^k


ENTER(sn_shift_down)

        movq   %rsi,    %rax            # rax <- la
        movq   %rdi,    %rsi            # rsi <- &a
        movq   %rdx,    %rdi            # rdi <- &b
        movq   %rax,    %rdx            # rdx <- la
        jrcxz  L(copy)                  # si k=0, copie simple
        call   .Lsn_fshift_down         # sinon, effectue le dcalage
        decq   %rdx
        shrq   %cl,     %rdx            # rdx <- 2^k - 1
        andq   %rdx,    %rax            # isole les k bits de poids faible de a[0]
        RETURN_WITH_SP
        
        # si k=0, b <- a
        ALIGN(4)
L(copy):
        leaq  -8(%rsi,%rdx,8), %rsi
        leaq  -8(%rdi,%rdx,8), %rdi
        movq   %rdx,    %rcx
        std;   rep movsq; cld
        xorq   %rax,   %rax
        RETURN_WITH_SP

        # cas o la version assembleur est dsactive :
        # sn_fshift_down renvoie vers la version C
#else
        ALIGN(32)
.Lsn_fshift_down:

        movq  (%rsi), %r15              # sauve a[0]
	movq   %rsi,  %r14              # sauve les paramtres
	movq   %rdi,  %r13
	movq   %rcx,  %r12
	
	movq   %r14,  %rdi
	movq   %rdx,  %rsi
	movq   %r13,  %rdx
        call   SUBR(sn_shift_down)
	
	movq   %r14,  %rsi              # rcupre les paramtres
	movq   %r13,  %rdi
	movq   $64,   %rcx
        subq   %rcx,  %r12              # rcx <- 64-k
        movq   %r15,  %rax              # rax <- a[0]
        movq   (%rdi),%rbx              # rbx <- b[0]
        xorq   %rdx,  %rdx              # rdx <- 0
        ret
        
#endif /* assembly_sn_shift_down */

                  # +-------------------------------------+
                  # |  Dcalage par adresses croissantes  |
                  # +-------------------------------------+

# entre :
#   a = naturel de longueur la     rsi = &a, rdx = la
#   b = naturel de longueur la     rdi = &b
#   k = entier                     rcx = k
# contraintes : la > 0, 0 < k < HW
#
# sortie :
#   b <- a << k
#
# registres modifis :
#   rax = a[la-1],  rbx = b[la-1]
#   rsi = &a[la],   rdi = &b[la]
#   rcx = 64-k,     rdx = 0

#ifdef assembly_sn_shift_up
#undef L
#define L(x) .Lsn_fshift_up_##x
        ALIGN(32)
.Lsn_fshift_up:

        subq   $64,     %rcx
        negq   %rcx                     # rcx <- 64-k
        xorq   %rbx,    %rbx            # init retenues
        movq   %rbx,    %rax
        leaq   (%rsi,%rdx,8), %rsi      # rsi <- &a[la]        
        leaq   (%rdi,%rdx,8), %rdi      # rdi <- &b[la]        
        negq   %rdx
        btrq   $0,      %rdx            # si la est impair, ...
        jc     2f                       # saute en milieu de boucle

        # corps de boucle droule 2 fois
        ALIGN(8)
1:
        movq   (%rsi,%rdx,8), %rbx
        shrdq  %cl, %rbx, %rax
        movq   %rax, (%rdi,%rdx,8)
2:
        movq   8(%rsi,%rdx,8), %rax
        shrdq  %cl, %rax, %rbx
        movq   %rbx, 8(%rdi,%rdx,8)
        addq   $2,  %rdx
        jne    1b
        ret

        
                              # +---------------+
                              # |  Interface C  |
                              # +---------------+
        
# chiffre xn(shift_up)(chiffre *a, long la, chiffre *b, int k)
#
# entre :
#   a = naturel de longueur la > 0
#   b = naturel de longueur la, peut tre confondu avec a
#   k = entier tel que 0 <= k < HW
#
# sortie :
#   b <- a << k
#   retourne les k bits de poids fort de a

ENTER(sn_shift_up)

        movq   %rsi,    %rax            # rax <- la
        movq   %rdi,    %rsi            # rsi <- &a
        movq   %rdx,    %rdi            # rdi <- &b
        movq   %rax,    %rdx            # rdx <- la
        jrcxz  L(copy)                  # si k=0, copie simple
        call   .Lsn_fshift_up           # sinon, effectue le dcalage
        shrq   %cl,    %rax             # isole les k bits de poids fort de a[la-1]
        RETURN_WITH_SP
        
        # si k=0, b <- a
        ALIGN(4)
L(copy):
        movq   %rdx,    %rcx
        cld;   rep movsq
        xorq   %rax,    %rax
        RETURN_WITH_SP

        # cas o la version assembleur est dsactive :
        # sn_fshift_up renvoie vers la version C
#else
        ALIGN(32)
.Lsn_fshift_up:

        movq  -8(%rsi,%rdx,8), %r15     # sauve a[la-1]
	movq   %rsi,  %r14              # sauve les paramtres
	movq   %rdi,  %r13
	movq   %rcx,  %r12
	movq   %rdx,  %rbx
	
	movq   %r14,  %rdi
	movq   %rdx,  %rsi
	movq   %r13,  %rdx
        call   SUBR(sn_shift_up)
	
	movq   %r14,  %rsi              # rcupre les paramtres
	movq   %r13,  %rdi
	movq   $64,   %rcx
        subq   %rcx,  %r12              # rcx <- 64-k
        leaq   (%rsi,%rbx,8), %rsi      # rsi <- &a[la-1]
        leaq   (%rdi,%rbx,8), %rdi      # rsi <- &b[la-1]
        movq   %r15,  %rax              # rax <- a[la-1]
        movq   -8(%rdi),%rbx            # rbx <- b[la-1]
        xorq   %rdx,    %rdx            # rdx <- 0
        ret
        
#endif /* assembly_sn_shift_up */

