// file kernel/n/ppc32/dumpreg.S: debugging facilities
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                   Affichage des registres Power PC                    |
 |                                                                       |
 +-----------------------------------------------------------------------*/

#define DUMPREG \
	stmw  r0,  -128(r1)    @\
	mfxer r31	       @\
	mflr  r30	       @\
	mfctr r29	       @\
	mfcr  r28	       @\
	stmw  r28, -144(r1)    @\
	stwu  r1,  -200(r1)    @\
	bl    Lsn_dump_reg     @\
	lwz   r1,     0(r1)    @\
	lmw   r28, -144(r1)    @\
	mtxer r31	       @\
	mtlr  r30	       @\
	mtctr r29	       @\
	mtcr  r28	       @\
	lwz   r0,  -128(r1)    @\
	lmw   r2,  -120(r1)

#define L(x) Lsn_dump_##x
L(fmt):
	.asciz "cr= %08X  ctr=%08X  lr= %08X  xer=%08X\n"
L(fmt1):
	.asciz "r0= %08X  r1= %08X  r2= %08X  r3= %08X\n"
	.asciz "r4= %08X  r5= %08X  r6= %08X  r7= %08X\n"
	.asciz "r8= %08X  r9= %08X  r10=%08X  r11=%08X\n"
	.asciz "r12=%08X  r13=%08X  r14=%08X  r15=%08X\n"
	.asciz "r16=%08X  r17=%08X  r18=%08X  r19=%08X\n"
	.asciz "r20=%08X  r21=%08X  r22=%08X  r23=%08X\n"
	.asciz "r24=%08X  r25=%08X  r26=%08X  r27=%08X\n"
	.asciz "r28=%08X  r29=%08X  r30=%08X  r31=%08X\n"

Lsn_dump_reg:
	
	mflr   r28		; r28 <- adresse de retour
	bcl    20,31, L(here)	; r31 <- adresse format
L(here):mflr   r31
/*	addis  r31,  r31, ha16(L(fmt)-L(here)) */
	addi   r31,  r31, lo16(L(fmt)-L(here))
	la     r30,  56(r1)	; r30 <- adresse registres
	li     r29,  9		; r29 <- nb de lignes  afficher
1:
	mr     r3,   r31	;  affiche 4 registres  la fois
	lwz    r4,   0(r30)
	lwz    r5,   4(r30)
	lwz    r6,   8(r30)
	lwz    r7,  12(r30)
	bl    _printf$LDBLStub
	addi   r31,  r31,  lo16(L(fmt1)-L(fmt))
	addi   r30,  r30,  16
	addic. r29,  r29,  -1
	bne    1b

	mtlr   r28		; termin
	blr
	
#undef L