// file kernel/n/ppc32/add.S: addition/subtraction of natural integers
/*-----------------------------------------------------------------------+
 |  Copyright 2005-2006, Michel Quercia (michel.quercia@prepas.org)      |
 |                                                                       |
 |  This file is part of Numerix. Numerix is free software; you can      |
 |  redistribute it and/or modify it under the terms of the GNU Lesser   |
 |  General Public License as published by the Free Software Foundation; |
 |  either version 2.1 of the License, or (at your option) any later     |
 |  version.                                                             |
 |                                                                       |
 |  The Numerix Library is distributed in the hope that it will be       |
 |  useful, but WITHOUT ANY WARRANTY; without even the implied warranty  |
 |  of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU  |
 |  Lesser General Public License for more details.                      |
 |                                                                       |
 |  You should have received a copy of the GNU Lesser General Public     |
 |  License along with the GNU MP Library; see the file COPYING. If not, |
 |  write to the Free Software Foundation, Inc., 59 Temple Place -       |
 |  Suite 330, Boston, MA 02111-1307, USA.                               |
 +-----------------------------------------------------------------------+
 |                                                                       |
 |                         Addition/soustraction                         |
 |                                                                       |
 +-----------------------------------------------------------------------*/

                           ; +---------------------+
                           ; |  Addition droule  |
                           ; +---------------------+

   ; entre en milieu de boucle :
   ;   r3 + CA = retenue entrante (dont le 1er chiffre de (r10))
   ;   ctr  = ceil(l/32)
   ;   r10 = adresse oprande cadre sur un multiple de 32
   ;   r11 = adresse oprande cadre sur un multiple de 32
   ;   r12 = adresse rsultat cadre sur un multiple de 32
   ;
   ; sortie:
   ;   (r12) <- (r10) + (r11)
   ;   CA <- retenue sortante
   ;   r3 <- dernier chiffre du rsultat
   ;
   ; registres modifis:
   ;   ctr <- 0
   ;   r4 <- ind
   ;   r10 <- adresse suivante pour le premier oprande
   ;   r11 <- adresse suivante pour le deuxime oprande
   ;   r12 <- adresse suivante pour le rsultat

        ; corps de boucle  drouler (4 instructions, entrer  la 2me)
#define BODY(x) \
        lwz    r3,   x(r10)     @\
        lwz    r4,   x(r11)     @\
        adde   r3,   r3,   r4   @\
        stw    r3,   x(r12)

	; boucle droule pour 32 chiffres
Lsn_addloop:
        BODY(0)@   BODY(4)@   BODY(8)@   BODY(12)
        BODY(16)@  BODY(20)@  BODY(24)@  BODY(28)
        BODY(32)@  BODY(36)@  BODY(40)@  BODY(44)
        BODY(48)@  BODY(52)@  BODY(56)@  BODY(60)
        BODY(64)@  BODY(68)@  BODY(72)@  BODY(76)
        BODY(80)@  BODY(84)@  BODY(88)@  BODY(92)
        BODY(96)@  BODY(100)@ BODY(104)@ BODY(108)
        BODY(112)@ BODY(116)@ BODY(120)@ BODY(124)
#undef BODY

	addi   r10,  r10,   128
	addi   r11,  r11,   128
	addi   r12,  r12,   128
	bdnz   Lsn_addloop
	blr


                               ; +------------+
                               ; |  Addition  |
                               ; +------------+

   ;  chiffre xn(add)(chiffre *a, long la, chiffre *b, long lb, chiffre *c)
   ; 
   ;  entre :
   ;  a = naturel de longueur la
   ;  b = naturel de longueur lb <= la
   ;  c = aturel de longueur la
   ; 
   ;  sortie :
   ;  c <- a + b
   ;  retourne la retenue

#ifdef assembly_sn_add
#define L(x) Lsn_add_##x
#define _a_  r10
#define _b_  r11
#define _c_  r12
#define _la_ r2
#define _lb_ r6

.globl _sn_add
_sn_add:
Lsn_add:

        mflr    r0              ; r0  <- adresse de retour

	; additionne les chiffres communs
        neg    r8,   _lb_       ; r8 <- -lb
	subf   _la_, _lb_, r4   ; la <- la - lb
	addi   _lb_, _lb_, 31   ; lb <- ceil(lb/32), CA <- 0
	srawi. _lb_, _lb_, 5 
        clrlslwi r8, r8,   27,2 ; r8 <- 4*((-lb) % 32)
	subf   _a_,  r8,   r3   ; cadre a,b,c sur le multiple de 32 prcdent
	subf   _b_,  r8,   r5
	subf   _c_,  r8,   r7
        beq-   1f               ; si lb = 0, pas de chiffres communs
        mtctr  _lb_             ; ctr <- ceil(lb/32)
	bcl    20,31, L(here)   ; lr <- adresse d entre dans la boucle
L(here):
	mflr   r9
/*	addis  r9,   r9, ha16(Lsn_addloop - L(here)) */
	addi   r9,   r9, lo16(Lsn_addloop - L(here))
        slwi   r8,   r8,   2
	add    r9,   r9,   r8
        mtlr   r9
	blrl   	                ; effectue l addition
1:

        ; propage la retenue
	and.   _la_, _la_, _la_
        beq     3f
	mtctr  _la_
	subi   _a_,  _a_,  4
	subi   _c_,  _c_,  4
2:
        lwzu   r3,   4(_a_)     ; r3 <- a[i]
        addze  r3,   r3         ; r3 += r
        stwu   r3,   4(_c_)     ; c[i] <- low(res)
        bdnz   2b
3:
        mtlr   r0
	li     r3,   0          ; r3 <- CA
	addze  r3,   r3
	blr

#undef L
#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_
#else
REPLACE(sn_add)
#endif /* assembly_sn_add */

                            ; +------------------+
                            ; |  Incrmentation  |
                            ; +------------------+

   ;  chiffre xn(inc)(chiffre *a, long la, chiffre *b, long lb)
   ;  entre :
   ;  a = naturel de longueur la
   ;  b = naturel de longueur lb avec lb <= la
   ;
   ;  sortie :
   ;  a <- a + b
   ;  retourne la retenue

#ifdef assembly_sn_inc
#define L(x) Lsn_inc_##x
#define _a_  r10
#define _b_  r11
#define _c_  r12
#define _la_ r2
#define _lb_ r6

.globl _sn_inc
_sn_inc:
Lsn_inc:

        mflr    r0              ; r0  <- adresse de retour

	; additionne les chiffres communs
        neg    r8,   _lb_       ; r8 <- -lb
	subf   _la_, _lb_, r4   ; la <- la - lb
	addi   _lb_, _lb_, 31   ; lb <- ceil(lb/32), CA <- 0
	srawi. _lb_, _lb_, 5 
        clrlslwi r8, r8,   27,2 ; r8 <- 4*((-lb) % 32)
	subf   _a_,  r8,   r3   ; cadre a,b,c sur le multiple de 32 prcdent
	subf   _b_,  r8,   r5
	mr     _c_,  _a_
        beq-   1f               ; si lb = 0, pas de chiffres communs
        mtctr  _lb_             ; ctr <- ceil(lb/32)
	bcl    20,31, L(here)   ; lr <- adresse d entre dans la boucle
L(here):
	mflr   r9
/*	addis  r9,   r9, ha16(Lsn_addloop - L(here)) */
	addi   r9,   r9, lo16(Lsn_addloop - L(here))
        slwi   r8,   r8,   2
	add    r9,   r9,   r8
        mtlr   r9
	blrl   	                ; effectue l addition
1:
        ; propage la retenue
	subfe. r3,   r3,   r3	; r3 <- CA - 1
        bne    3f
	and.   _la_, _la_, _la_
        beq    3f
	mtctr  _la_
	subi   _c_,  _c_,  4
2:
	lwz    r4,   4(_c_)
	addze. r4,   r4
	stwu   r4,   4(_c_)
	bdnzt  eq,   2b
	subfe  r3,   r3,   r3
3:
	addi   r3,   r3,   1	; r3 <- CA
        mtlr   r0
	blr
	
	
#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_
#undef L
#else
REPLACE(sn_inc)
#endif /* assembly_sn_inc */

                         ; +-------------------------+
                         ; |  Soustraction droule  |
                         ; +-------------------------+

   ; entre en milieu de boucle :
   ;   r3 + CA = retenue entrante (dont le 1er chiffre de (r10))
   ;   ctr  = ceil(l/32)
   ;   r10 = adresse oprande cadre sur un multiple de 32
   ;   r11 = adresse oprande cadre sur un multiple de 32
   ;   r12 = adresse rsultat cadre sur un multiple de 32
   ;
   ; sortie:
   ;   (r12) <- (r10) - (r11)
   ;   CA <- retenue sortante
   ;   r3 <- dernier chiffre du rsultat
   ;
   ; registres modifis:
   ;   ctr <- 0
   ;   r4 <- ind
   ;   r10 <- adresse suivante pour le premier oprande
   ;   r11 <- adresse suivante pour le deuxime oprande
   ;   r12 <- adresse suivante pour le rsultat

        ; corps de boucle  drouler (4 instructions, entrer  la 2me)
#define BODY(x) \
        lwz    r3,   x(r10)     @\
        lwz    r4,   x(r11)     @\
        subfe  r3,   r4,   r3   @\
        stw    r3,   x(r12)

	; boucle droule pour 32 chiffres
Lsn_subloop:
        BODY(0)@   BODY(4)@   BODY(8)@   BODY(12)
        BODY(16)@  BODY(20)@  BODY(24)@  BODY(28)
        BODY(32)@  BODY(36)@  BODY(40)@  BODY(44)
        BODY(48)@  BODY(52)@  BODY(56)@  BODY(60)
        BODY(64)@  BODY(68)@  BODY(72)@  BODY(76)
        BODY(80)@  BODY(84)@  BODY(88)@  BODY(92)
        BODY(96)@  BODY(100)@ BODY(104)@ BODY(108)
        BODY(112)@ BODY(116)@ BODY(120)@ BODY(124)
#undef BODY

	addi   r10,  r10,   128
	addi   r11,  r11,   128
	addi   r12,  r12,   128
	bdnz   Lsn_subloop
	blr


                             ; +----------------+
                             ; |  Soustraction  |
                             ; +----------------+

   ;  chiffre xn(sub)(chiffre *a, long la, chiffre *b, long lb, chiffre *c)
   ; 
   ;  entre :
   ;  a = naturel de longueur la
   ;  b = naturel de longueur lb <= la
   ;  c = aturel de longueur la
   ; 
   ;  sortie :
   ;  c <- a - b
   ;  retourne la retenue

#ifdef assembly_sn_sub
#define L(x) Lsn_sub_##x
#define _a_  r10
#define _b_  r11
#define _c_  r12
#define _la_ r2
#define _lb_ r6

.globl _sn_sub
_sn_sub:
Lsn_sub:
	
        mflr    r0              ; r0  <- adresse de retour

	; retranche les chiffres communs
        neg    r8,   _lb_       ; r8 <- -lb
	addi   r9,   _lb_, 31   ; r9 <- ceil(lb/32)
	srawi. r9,   r9,   5 
        clrlslwi r8, r8,   27,2 ; r8 <- 4*((-lb) % 32)
	subf   _a_,  r8,   r3   ; cadre a,b,c sur le multiple de 32 prcdent
	subf   _b_,  r8,   r5
	subf   _c_,  r8,   r7
	subfc  _la_, _lb_, r4   ; la <- la - lb, CA <- 1
        beq-   1f               ; si lb = 0, pas de chiffres communs
        mtctr  r9               ; ctr <- ceil(lb/32)
	bcl    20,31, L(here)   ; lr <- adresse d entre dans la boucle
L(here):
	mflr   r9
/*	addis  r9,   r9, ha16(Lsn_subloop - L(here)) */
	addi   r9,   r9, lo16(Lsn_subloop - L(here))
        slwi   r8,   r8,   2
	add    r9,   r9,   r8
        mtlr   r9
	blrl   	                ; effectue la soustraction
1:

        ; propage la retenue
	and.   _la_, _la_, _la_
        beq     3f
	mtctr  _la_
	li     r4,   0
	subi   _a_,  _a_,  4
	subi   _c_,  _c_,  4
2:
        lwzu   r3,   4(_a_)     ; r3 <- a[i]
        subfe  r3,   r4,   r3   ; r3 -= r
        stwu   r3,   4(_c_)     ; c[i] <- low(res)
        bdnz   2b
3:
	subfe  r3,   r3,   r3   ; r3 <- 1 - CA
	neg    r3,   r3
        mtlr   r0
	blr

#undef L
#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_
#else
REPLACE(sn_sub)
#endif /* assembly_sn_sub */

                            ; +------------------+
                            ; |  Dcrmentation  |
                            ; +------------------+

   ;  chiffre xn(dec)(chiffre *a, long la, chiffre *b, long lb)
   ;  entre :
   ;  a = naturel de longueur la
   ;  b = naturel de longueur lb avec lb <= la
   ;
   ;  sortie :
   ;  a <- a - b
   ;  retourne la retenue

#ifdef assembly_sn_dec
#define L(x) Lsn_dec_##x
#define _a_  r10
#define _b_  r11
#define _c_  r12
#define _la_ r2
#define _lb_ r6

.globl _sn_dec
_sn_dec:
Lsn_dec:

        mflr    r0              ; r0  <- adresse de retour

	; retranche les chiffres communs
        neg    r8,   _lb_       ; r8 <- -lb
	addi   r9,   _lb_, 31   ; lb <- ceil(lb/32)
	srawi. r9,   r9,   5 
        clrlslwi r8, r8,   27,2 ; r8 <- 4*((-lb) % 32)
	subf   _a_,  r8,   r3   ; cadre a,b,c sur le multiple de 32 prcdent
	subf   _b_,  r8,   r5
	mr     _c_,  _a_
	subfc  _la_, _lb_, r4   ; la <- la - lb, CA <- 1
        beq-   1f               ; si lb = 0, pas de chiffres communs
        mtctr  r9               ; ctr <- ceil(lb/32)
	bcl    20,31, L(here)   ; lr <- adresse d entre dans la boucle
L(here):
	mflr   r9
/*	addis  r9,   r9, ha16(Lsn_subloop - L(here)) */
	addi   r9,   r9, lo16(Lsn_subloop - L(here))
        slwi   r8,   r8,   2
	add    r9,   r9,   r8
        mtlr   r9
	blrl   	                ; effectue la soustraction
1:
        ; propage la retenue
	subfe. r3,   r3,   r3   ; r3 <- CA - 1
        beq    3f
	and.   _la_, _la_, _la_
        beq    3f
	mtctr  _la_
	subi   _c_,  _c_,  4
2:
	lwz    r4,   4(_c_)
	and.   r4,   r4,   r4
	addme  r4,   r4
	stwu   r4,   4(_c_)
	bdnzt  eq,   2b
	subfe  r3,   r3,   r3
3:
	neg    r3,   r3		; r3 <- 1 - CA
        mtlr   r0
	blr
	
	
#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_
#undef L
#else
REPLACE(sn_dec)
#endif /* assembly_sn_dec */


                    ; +-----------------------------------+
                    ; |  Valeur absolue de la diffrence  |
                    ; +-----------------------------------+

   ; chiffre xn(asub)(chiffre *a, long la, chiffre *b, long lb, chiffre *c)
   ; entre :
   ;   a = naturel de longueur la
   ;   b = naturel de longueur lb
   ;   c = naturel de longueur la, peut tre confondu avec a ou b
   ; contraintes : la >= lb > 0
   ;
   ; sortie :
   ;   c <- |a-b|
   ;   r2 <- 0 si a >= b, 1 sinon
   ;
   ; remarque :
   ;   fonction non implmente en C

#define L(x) Lsn_asub_##x
#define _a_  r3
#define _b_  r5
#define _c_  r7
#define _la_ r9
#define _lb_ r6

Lsn_asub:

	slwi   _la_, r4,   2    ; la <- la - lb, lb <- 4*(lb-1)
	slwi   _lb_, _lb_, 2
        subf.  _la_, _lb_, _la_
	addi   _lb_, _lb_, -4
	add    r10,  _lb_, _a_  ; r10 <- &a[lb-1]
	add    r12,  _lb_, _c_  ; r12 <- &c[lb-1]
	li     r2,   0          ; r2 <- 0 (rsultat)

	; recopie les zros de tte de a tant que la > lb
	beq    2f
1:
	lwzx   r8,   r10, _la_
	and.   r8,   r8,   r8
	bne+   4f
	stwx   r8,   r12,  _la_
	addic. _la_, _la_, -4
	bne    1b
	
	; soustrait les chiffres de poids fort de a et b tant qu ils sont gaux
2:
	lwzx   r2,   _a_,  _lb_
	lwzx   r8,   _b_,  _lb_
	subfc. r2,   r8,   r2	; CA <- signe(a[lb-1] - b[lb-1])
	bne+   3f
	stwx   r2,   _c_,  _lb_
	addic. _lb_, _lb_, -4
	bge    2b
        blr

	; ici a et b ont un chiffre de tte diffrent. Si a < b, les change
3:
	subfe  r2,   r2,   r2	; r2 <- signe(a-b)
	neg.   r2,   r2
	beq    4f
	mr     r8,   _a_
	mr     _a_,  _b_
	mr     _b_,  r8
4:

        mflr    r0              ; r0  <- adresse de retour
	srawi  _la_,  _la_, 2   ;  restaure la-lb et lb
	srawi  _lb_,  _lb_, 2
	addi   _lb_,  _lb_, 1

	; retranche les chiffres communs
        neg    r8,   _lb_       ; r8 <- -lb
	addi   _lb_, _lb_, 31   ; lb <- ceil(lb/32)
	srawi. _lb_, _lb_, 5 
        clrlslwi r8, r8,   27,2 ; r8 <- 4*((-lb) % 32)
	subf   r10,  r8,   _a_  ; cadre a,b,c sur le multiple de 32 prcdent
	subf   r11,  r8,   _b_
	subf   r12,  r8,   _c_
	subfc  r4,   r4,   r4	; CA <- 1
	beq-   1f               ; si lb = 0, pas de chiffres communs
        mtctr  _lb_             ; ctr <- ceil(lb/32)
	bcl    20,31, L(here)   ; lr <- adresse d entre dans la boucle
L(here):
	mflr   r4
/*	addis  r4,   r4, ha16(Lsn_subloop - L(here)) */
	addi   r4,   r4, lo16(Lsn_subloop - L(here))
        slwi   r8,   r8,   2
	add    r4,   r4,   r8
        mtlr   r4
	blrl   	                ; effectue la soustraction
1:

        ; propage la retenue
        mtlr   r0
	and.   _la_, _la_, _la_
        beqlr
	mtctr  _la_
	li     r4,   0
2:
        lwz    r3,   0(r10)     ; r3 <- a[i]
        subfe  r3,   r4,   r3   ; r3 -= r
        stw    r3,   0(r12)     ; c[i] <- low(res)
        addi   r10,  r10,  4    ; a++
        addi   r12,  r12,  4    ; c++
        bdnz   2b
	blr

#undef L
#undef _a_
#undef _b_
#undef _c_
#undef _la_
#undef _lb_

                      ; +------------------------------+
                      ; |  demi-addition-soustraction  |
                      ; +------------------------------+

; void xn(half_add_sub)(chiffre *a, chiffre *b, chiffre *c, chiffre *d, long n)
; entre :
;   a,b,c,d = naturels de longueur n
;
; contraintes :
;   n > 0, c non confondu avec b ou d
;
; sortie :
;   c  <- floor((a+b)/2)
;   d  <- floor((a-b)/2) mod BASE^n
;   CA <- retenue de a-b
;   r6 <- (a+b) mod 2
;
; remarque :
;   fonction non implmente en C

#define L(x) Lsn_half_add_sub_##x
Lsn_half_add_sub:

        mflr    r0              ; r0  <- adresse de retour

        neg    r8,   r7         ; r8 <- -n
	addi   r7,   r7,   31   ; r7 <- ceil(n/32), CA <- 0
	srawi  r7,   r7,    5 
        clrlslwi r8, r8,   27,2 ; r8 <- 4*((-n) % 32)
	subf   r9,   r8,   r3   ; cadre a,b,c,d sur le multiple de 32 prcdent
	subf   r11,  r8,   r4
	subf   r10,  r8,   r5
	subf   r12,  r8,   r6
	subi   r10,  r10,   4	; recule c d un chiffre
	bcl    20,31, L(here)   ; lr <- adresse d entre dans la boucle
L(here):
	mflr   r2
	addi   r5,   r2, lo16(L(loop) - L(here) + 20)
/*	addis  r5,   r5, ha16(L(loop) - L(here) + 20) */
        mulli  r6,   r8,   6
	add    r5,   r5,   r6
        mtlr   r5
        mtctr  r7               ; ctr <- ceil(n/32)
	lwz    r3,  0(r3)	; CA:r3 <- a[0] + b[0]
	lwz    r4,  0(r4)
	addc   r3,  r4,   r3
	andi.  r6,  r3,   1
	bclr   20,31,3		; c <- (a+b)2

        ; corps de boucle  drouler (6 instructions, entrer  la 6me)
#define BODY(x) \
	lwz    r3,   x(r9)      @\
	lwz    r4,   x(r11)	@\
        adde   r3,   r4,   r3	@\
	insrwi r5,   r3,   1,0	@\
	stw    r5,   x(r10)	@\
	srwi   r5,   r3,   1

	; boucle droule pour 32 chiffres
L(loop):
        BODY(0)@   BODY(4)@   BODY(8)@   BODY(12)
        BODY(16)@  BODY(20)@  BODY(24)@  BODY(28)
        BODY(32)@  BODY(36)@  BODY(40)@  BODY(44)
        BODY(48)@  BODY(52)@  BODY(56)@  BODY(60)
        BODY(64)@  BODY(68)@  BODY(72)@  BODY(76)
        BODY(80)@  BODY(84)@  BODY(88)@  BODY(92)
        BODY(96)@  BODY(100)@ BODY(104)@ BODY(108)
        BODY(112)@ BODY(116)@ BODY(120)@ BODY(124)
#undef BODY
	
	addi   r9,   r9,   128
	addi   r11,  r11,  128
	addi   r10,  r10,  128
	bdnz   L(loop)
	li     r3,   0		; sauve le dernier chiffre
	addze  r3,   r3
	insrwi r5,   r3,   1,0
	stw    r5, 0(r10)

	addi   r2,   r2, lo16(Lsn_subloop - L(here))
/*	addis  r2,   r2, ha16(Lsn_subloop - L(here)) */
        slwi   r4,   r8,   2
	add    r2,   r2,   r4
        mtlr   r2		; lr <- adresse entre dans la boucle
        mtctr  r7               ; ctr <- ceil(n/32)
	slwi   r7,   r7,   7	; recadre les pointeurs
	subf   r10,  r7,   r10
	addi   r10,  r10,  4
	subf   r11,  r7,   r11
	subfc  r3,   r3,   r3	; CA <- 1
	blrl			; d <- c - b

	mtlr   r0		; termin
	blr

#undef L
