
/*
 ** Copyright(C) 2003 Eric Leblond <eric@regit.org>
 **		     Vincent Deffontaines <vincent@gryzor.com>
 **
 ** This program is free software; you can redistribute it and/or modify
 ** it under the terms of the GNU General Public License as published by
 ** the Free Software Foundation, version 2 of the License.
 **
 ** This program is distributed in the hope that it will be useful,
 ** but WITHOUT ANY WARRANTY; without even the implied warranty of
 ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 ** GNU General Public License for more details.
 **
 ** You should have received a copy of the GNU General Public License
 ** along with this program; if not, write to the Free Software
 ** Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <auth_srv.h>
#include <string.h>
#include <errno.h>


G_MODULE_EXPORT gint user_packet_logs (connection* element, int state)
{
    char *str_state="Unknown ";
    char* source_addr;
    char* dest_addr;
    struct in_addr oneip;

    /* contruct request */
    switch (state) {
      case CONN_STATE_OPEN:
          str_state="Open ";
          break;
      case CONN_STATE_CLOSE:
          str_state="Close ";
          break;
      case CONN_STATE_ESTABLISHED:
          str_state="Established ";
          break;
      case CONN_STATE_DROP:
          str_state="Drop ";
          break;
      default:
          str_state="Unknown ";
    } 
    oneip.s_addr=htonl((element->tracking_hdrs).saddr);
    source_addr=g_strdup(inet_ntoa(oneip));
    oneip.s_addr=htonl((element->tracking_hdrs).daddr);
    dest_addr=g_strdup(inet_ntoa(oneip));

    if ( ((element->tracking_hdrs).protocol == IPPROTO_TCP) || ((element->tracking_hdrs).protocol == IPPROTO_UDP) ) {
	    g_message("%s[%s] %ld : SRC=%s DST=%s PROTO=%d SPT=%u DPT=%u (app=%s)",
			    str_state,
			    element->username,
			    element->timestamp,
			    dest_addr,
			    source_addr,
			    (element->tracking_hdrs).protocol,
			    (element->tracking_hdrs).dest,
			    (element->tracking_hdrs).source,
			    element->appname
		     );
    } else {
        g_message("%s[%s] %ld : SRC=%s DST=%s PROTO=%d",
            str_state,
            element->username,
            element->timestamp,
            source_addr,
            dest_addr,
            (element->tracking_hdrs).protocol
            );
    }
    g_free(source_addr);
    g_free(dest_addr);
    return 0;
}

