/*
 * Copyright (c) 1995 University College London
 * All rights reserved.
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the Computer Science
 *      Department at University College London
 * 4. Neither the name of the University nor of the Department may be used
 *    to endorse or promote products derived from this software without
 *    specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>

#include "prototypes.h"
#include "tcl.h"
#include "tk.h"
#include <string.h>
#include <fcntl.h>
#include <errno.h>




#ifndef WIN32
#include <sys/file.h>
#define NBCONNECT
#endif

#ifndef INADDR_NONE
#define INADDR_NONE     0xffffffff
#endif

extern char *help[];
extern char *helpdata[];
extern int no_of_help;
char *webdata = NULL;
int webblocks = 0;
#define BLOCKSIZE 100000
#define READSIZE 1024
int webdatalen;
#ifdef DEBUG
static char msg[80];
#endif
int stoploading = 0;

static int www_perror(Tcl_Interp *, char *, int);

int webto(dummy, interp, argc, argv)
ClientData dummy;		/* Not used. */
Tcl_Interp *interp;		/* Current interpreter. */
int argc;			/* Number of arguments. */
char **argv;
{
    char uridata[1024];
    char *uri, *end, *t1, *t2, *proto;
    struct sockaddr_in sinhim;
    struct hostent *addr;
    unsigned long inaddr;
    int fd, i, usingproxy;
    int webstate;

    UNUSED(dummy);
#define	CONNECTING	1
#define	READING		2

    if (webdata == NULL) {
	webdata = malloc(BLOCKSIZE);
	webblocks = 1;
    }
    stoploading = 0;
    if (argc < 2 || argc > 3) {
	sprintf(interp->result, "Content-Type: text/html\n\nusage: webto url [proxy] [argc=%d]\n", argc);
	return TCL_OK;
    }
    usingproxy = (argc == 3 && *argv[2]);
    strncpy(uridata, argv[1], 1024);
    debug("URI: %s\n", uridata);
    uri = uridata;
    proto = uri;
    end = strchr(uri, ':');
    if (end == 0) {
	fprintf(stderr, "Parse error in URL: %s\n", uri);
	strcpy(interp->result, "Content-Type: text/html\n\nParse error in URL\n");
	return TCL_OK;
    }
    *end = '\0';
    if (strncmp(proto, "help", 4) == 0) {
	debug("Page: %s\n", end + 1);
	strcpy(webdata, "Content-Type: text/html\n\n");
	for (i = 0; i < no_of_help; i++) {
	    if (strcmp(end + 1, help[i]) == 0)
		strcat(webdata, helpdata[i]);
	}
	interp->result = webdata;
    } else if (strncmp(proto, "http", 4) == 0 || usingproxy) {
	int port = 80;
	char file[256];

	if (usingproxy) {	/* Using proxy */
	    uri = argv[2];
	    *end = ':';
	    strncpy(file, argv[1], sizeof(file) - 1);
	} else {
	    uri = end + 3;
	    t1 = strchr(uri, '/');
	    if (t1 == 0) {
		strcpy(file, "/");
	    } else {
		*t1 = '\0';
		file[0] = '/';
		strncpy(&file[1], t1 + 1, sizeof(file) - 2);
	    }
	}
	t2 = strchr(uri, ':');
	if (t2 == 0) {
	    port = 80;
	} else {
	    port = atoi(t2 + 1);
	    *t2 = '\0';
	}
	debug("proto=http, host=%s, port=%d, file=%s\n", uri, port, file);
	if ((inaddr = inet_addr(uri)) != INADDR_NONE) {
	    /* it's dotted-decimal */
	    memcpy((char *) &sinhim.sin_addr.s_addr, (char *) &inaddr, sizeof(inaddr));
	    sinhim.sin_family = AF_INET;
	} else {
	    if ((addr = gethostbyname(uri)) == NULL) {
		sprintf(interp->result, "Content-Type: text/html\n\n<html><h1>Unknown Host</h1>%s does not exist</html>", uri);
		return TCL_OK;
	    }
	    sinhim.sin_family = addr->h_addrtype;
	    sinhim.sin_family = AF_INET;
	    sinhim.sin_port = htons(port);
#ifdef h_addr
	    memcpy((char *) &sinhim.sin_addr, addr->h_addr_list[0], addr->h_length);
#else
	    memcpy((char *) &sinhim.sin_addr, addr->h_addr, addr->h_length);
#endif
	}

	Tcl_SetVar2(interp, "webstatus", NULL, "Connecting...", TCL_GLOBAL_ONLY);
	Tcl_Eval(interp, "webstatus");
	while (Tk_DoOneEvent(TK_DONT_WAIT));
	if ((fd = socket(AF_INET, SOCK_STREAM, 0)) < 0) {
	    return www_perror(interp, "socket", errno);
	}
#ifdef NBCONNECT
	fcntl(fd, F_SETFL, FNDELAY);
#endif

	if (connect(fd, (struct sockaddr *) &sinhim, sizeof(struct sockaddr_in)) < 0
#ifdef NBCONNECT
	    && errno != EINPROGRESS
#endif
	) {
	    return www_perror(interp, "connect", errno);
	}
	webdatalen = 0;
	webstate = CONNECTING;
	while (stoploading == 0) {
	    int tmp;
	    fd_set r, w;
	    struct timeval tv;

	    tv.tv_sec = 0;
	    tv.tv_usec = 100000;
	    FD_ZERO(&r);
	    if (webstate == READING)
		FD_SET(fd, &r);
	    FD_ZERO(&w);
	    if (webstate == CONNECTING)
		FD_SET(fd, &w);

	    if (select(fd + 1, &r, &w, NULL, &tv) != 0) {
		if (webstate == CONNECTING) {
#ifdef NBCONNECT
		    /* this is throwing the warning, should be a char */
		    int err = 0;
		    int errlen = sizeof(err);

		    if (getsockopt(fd, SOL_SOCKET, SO_ERROR, (char *) &err, &errlen) < 0) {
			if (errno == EPIPE) {
			    /*
			     * Solaris's socket emulation doesn't allow this operation.
			     * However, instead of saying "getsockopt: broken pipe",
			     * we create a fake error message for connect.
			     */
			    err = ENOTCONN;
			} else {
			    return www_perror(interp, "getsockopt", errno);
			}
		    }
		    if (err != 0) {
			return www_perror(interp, "connect", err);
		    }
		    fcntl(fd, F_SETFL, 0);
#endif
		    sprintf(webdata, "GET %s HTTP/1.0\r\n", file);
		    send(fd, webdata, strlen(webdata), 0);
		    sprintf(webdata, "Accept: text/plain\r\nAccept: text/html\r\nAccept: image/*\r\n\r\n");
		    send(fd, webdata, strlen(webdata), 0);
		    Tcl_SetVar2(interp, "webstatus", NULL, "Receiving...", TCL_GLOBAL_ONLY);
		    Tcl_Eval(interp, "webstatus");
		    webstate = READING;
		    continue;
		}
		if ((webdatalen + READSIZE) > (webblocks * BLOCKSIZE)) {
		    webblocks++;
		    webdata = realloc(webdata, webblocks * BLOCKSIZE);
		}
		tmp = recv(fd, &webdata[webdatalen], READSIZE, 0);
		if (tmp <= 0) {
		    break;
		}
		webdatalen += tmp;
#ifdef DEBUG
		sprintf(msg, "Read %d bytes", webdatalen);
		printf("%s", msg);
		Tcl_SetVar2(interp, "webstatus", NULL, msg, TCL_GLOBAL_ONLY);
		if (Tcl_Eval(interp, "webstatus") != 0) {
		    printf("%s\n", interp->result);
		}
#endif
		Tcl_Eval(interp, "update");
	    } else {
		Tcl_Eval(interp, "show_active");
		while (Tk_DoOneEvent(TK_DONT_WAIT));
	    }
	}
	webdata[webdatalen] = '\0';
	interp->result = webdata;
	close(fd);
    } else if (strncmp(proto, "ftp", 3) == 0) {
	Tcl_VarEval(interp, "msgpopup", "Protocol Error", "Sorry - this browser does not yet support ftp URLs", NULL);
    } else if (strncmp(proto, "mailto", 6) == 0) {
	Tcl_VarEval(interp, "msgpopup", "Protocol Error", "Sorry - this browser does not yet support mailto URLs", NULL);
    } else {
	strcpy(interp->result, "Unknown protocol");
    }
    return TCL_OK;
}

static int www_perror(interp, who, err)
Tcl_Interp *interp;		/* Current Interpreter. */
char *who;			/* Function that errored */
int err;			/* Errno */
{
    char *p = strerror(err);

    if (p == NULL)
	sprintf(interp->result, "Content-Type: text/html\n\n"
		"<html><h1>Error</h1>"
		"%s: Unknown error %d"
		"</html>\n", who, err);
    else
	sprintf(interp->result, "Content-Type: text/html\n\n"
		"<html><h1>Error</h1>"
		"%s: %s"
		"</html>\n", who, p);
    return TCL_OK;
}

int save_www_data_to_file(dummy, interp, argc, argv)
ClientData dummy;		/* Not used. */
Tcl_Interp *interp;		/* Current interpreter. */
int argc;			/* Number of arguments. */
char **argv;
{
    FILE *file;
    UNUSED(dummy);
    UNUSED(interp);
    UNUSED(argc);
    file = fopen(argv[2], "w");
    fwrite(&webdata[atoi(argv[1])], 1, webdatalen - atoi(argv[1]), file);
    fclose(file);
    return TCL_OK;
}

int stop_www_loading()
{
    stoploading = 1;
    return TCL_OK;
}
