/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
 *   
 *    This program is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU General Public License
 *    as published by the Free Software Foundation; either version 2 
 *    of the License, or (at your option) any later version.
 *   
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *   
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * */

#include "ntaim.h"

extern preferences pref;
extern color_pref colors;
window_node *main_window = NULL;
window_node *window_head = NULL;
window_node *current_window = NULL;

int addwindowtolist(char *screenname, char isroom)
{
   window_node *cur = window_head;

   while(cur->next)
     cur = cur->next;
   
   cur->next = (window_node*) MALLOC(sizeof(window_node), "addwindowtolist");
   if(cur->next == NULL)
     {
	alert("error when allocating memory for window node.");
	return -1;
     }
   
   cur->next->window = newwin(LINES-2, (int)(COLS-(COLS*.2375) + .5), 0, 0);
   if(cur->next->window == NULL)
     {
	alert("error when allocating memory for new window.");
	FREE(cur, "addwindowtolist");
	return -1;
     }
   wbkgd(cur->next->window, CP(colors.mainfore, colors.mainback));
   scrollok(cur->next->window, TRUE);
   
   strcpy(cur->next->screenname, stripname(screenname));
   cur->next->isroom = isroom;
   cur->next->prev = cur;
   cur->next->next = NULL;
   
   return 0;

}

int removewindowfromlist(window_node *toremove)
{
   if(toremove == NULL) 
     return -1;
     
   if(toremove == main_window)
     {
	alert("can not remove main window!!");
	return -1;
     }
   
   if(toremove->prev)
     {
	if(toremove->next)
	  toremove->prev->next = toremove->next;
	else
	  toremove->prev->next = NULL;
     }

   if(toremove->next)
     {
	if(toremove->prev)
	  toremove->next->prev = toremove->prev;
     }
   
   if(toremove == current_window)
     {
	if(current_window->next)
	  current_window = current_window->next;
	else if(current_window->prev)
	  current_window = current_window->prev;
	else 
	  current_window = main_window;
	
	touchwin(current_window->window);
	wrefresh(current_window->window);
     }
   
   delwin(toremove->window);
   FREE(toremove, "removewindowfromlist");
   return 0;
}

window_node *windowfor(char *screenname, char isroom)
{
   window_node *cur = window_head;

   while(cur)
     {
	if(!strcmp(cur->screenname, stripname(screenname)))
	  {
	     if(cur->isroom == isroom)
	       return cur;
	  }
	else
	  cur = cur->next;
     }
   return NULL;
}

void clearwindows(void)
{
   while(window_head->next)
     removewindowfromlist(window_head->next);

   delwin(window_head->window);
   FREE(window_head, "shutdown_env: window");
}
