/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
   
    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2 
    of the License, or (at your option) any later version.
   
    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.
   
    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern window_node *main_window;
extern window_node *window_head;
extern window_node *current_window;
extern buddy_pounce_node *buddy_pounce_head;
extern color_pref colors;
extern int commandnum;
WINDOW *buddy_win;
WINDOW *chat_win;

void shutdown_env(int sig)
{
   clearbuddylist();
   clearcommandaliases();
   clearhistory();
   clearwindows();
   clearpounces();
   clearawaymessages();
   
   delwin(buddy_win);
   delwin(chat_win);
   endwin();
#ifdef DEBUG
   debug_close();
#endif
   exit(0);
}

void setup_env(void)
{
   int i, count = 0;

   commandnum = countcommands(); 
   loadawaymessages();
   
   if(!initscr())
     {
	write(1, "Error: could not initialize curses.\n", 36);
	exit(1);
     }
   cbreak();
   noecho();
   raw();
   erase();
   refresh();

   if(has_colors()) 
     start_color();
   
   for(i = 0; i < 8; i++)
     {
	int j;
	for(j = 0; j < 8; j++)
	  {
	     init_pair(++count, i, j);
	  }
     }
 
   main_window = (window_node*) MALLOC(sizeof(window_node), "setup_env");
   window_head = current_window = main_window;
   main_window->next = main_window->prev = NULL;
   main_window->screenname[0] = '\0';
   main_window->window = newwin(LINES-2, (int)(COLS-(COLS*.2375)+.5), 0,0);
   wbkgd(main_window->window, CP(colors.mainfore, colors.mainback));
   scrollok(main_window->window, TRUE);
   
   buddy_win = newwin(LINES-2, (int)((COLS*.2375)+.5), 0, (int)(COLS-(COLS*.2375)));
   wbkgd(buddy_win, CP(colors.budwinfore, colors.budwinback));
   
   chat_win = newwin( 2, COLS, LINES-2, 0);
   wbkgd(chat_win, CP(colors.chatfore, colors.chatback));
   scrollok(chat_win,TRUE);
}
