/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern window_node *main_window;
extern window_node *current_window;
extern preferences pref;
extern color_pref colors;

void alert(char *msg)
{
   wattrset(current_window->window, CP(colors.alertfore, colors.alertback)|A_BOLD);

   if(pref.verbose || pref.timestamp)
     {
	char tbuff[9];
	struct tm *time_info;
	time_t time_value;

	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime(tbuff, 9, "%X", time_info);
	wprintw(current_window->window, "%s ", tbuff);
     }
   wprintw(current_window->window, "ALERT: %s\n", msg);
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
   wrefresh(current_window->window);
}

void info(char *msg)
{
   wattrset(current_window->window, CP(colors.infofore, colors.infoback)|A_BOLD);
   if(pref.verbose || pref.timestamp)
     {
	char tbuff[9];
	struct tm *time_info;
	time_t time_value;

	time_value = time(NULL);
	time_info = localtime(&time_value);
	strftime(tbuff, 9, "%X", time_info);
	wprintw(current_window->window, "%s ", tbuff);
     }
   wprintw(current_window->window, "INFO: %s\n", msg);
   wattrset(current_window->window, CP(colors.mainfore, colors.mainback));
   wrefresh(current_window->window);
}
