/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public License
    as published by the Free Software Foundation; either version 2
    of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include "ntaim.h"

extern window_node *current_window;
extern color_pref colors;

void push_colors(color_node *head_node, unsigned short int foreground, unsigned short int background)
{
   color_node *cur = head_node;

   while(cur->next)
     cur = cur->next;

   cur->next = (color_node*)MALLOC(sizeof(color_node), "push_colors");
   cur = cur->next;
   cur->foreground = foreground;
   cur->background = background;
   cur->next = NULL;
}

color_node pop_colors(color_node *head_node)
{
   color_node *cur = head_node;
   color_node *prev;
   color_node popped;

   if(cur->next)
     {
	while(cur->next)
	  {
	     prev = cur;
	     cur = cur->next;
	  }

	memcpy(&popped, cur, sizeof(color_node));

	FREE(cur, "pop_colors");
	prev->next = NULL;

	return popped;
     }
   else if(head_node == cur)
     return *head_node;

   return *head_node;
}

color_node peek_colors(color_node *head_node)
{
   color_node *cur = head_node;
   color_node *prev;
   color_node popped;

   while(cur->next)
     {
	prev = cur;
	cur = cur->next;
     }

   memcpy(&popped, cur, sizeof(color_node));

   return popped;
}

void print_html(window_node *toprint, char *html)
{
   char putdash = FALSE;
   int dashcount = 0;
   int i, html_length;
   int fore_color = colors.mainfore;
   int back_color = colors.mainback;
   color_node *color_list;

   if(html)
     html_length = strlen(html);
   else
     return;

   color_list = (color_node*)MALLOC(sizeof(color_node), "print_html");
   if(color_list == NULL)
     return;

   color_list->foreground = fore_color;
   color_list->background = back_color;
   color_list->next = NULL;

   wattrset(toprint->window, CP(colors.mainfore, colors.mainback));

   for(i = 0; i < html_length; i++)
     {
	if(html[i] == '<')
	  {
	     static char in_trouble = FALSE;
	     int count = 0, orig_i_pos = i;
	     char *tag;

	     if(in_trouble == TRUE) /* tag previously parsed isnt known */
	       {
		  waddch(toprint->window, '<');
		  in_trouble = FALSE;
		  continue;
	       }

	     while(html[++i] != '>' && html[i])
	       count++;

	     tag = (char*)alloca(count+1);
	     if(tag == NULL)
	       return;
	     strncpy(tag, (char*)&html[i - count], count);
	     tag[count] = '\0';

	     if(!strcasecmp(tag, "B"))
	       wattron(toprint->window, A_BOLD);
	     else if(!strcasecmp(tag, "/B"))
	       wattroff(toprint->window, A_BOLD);
	     else if(!strcasecmp(tag, "U"))
	       wattron(toprint->window, A_UNDERLINE);
	     else if(!strcasecmp(tag, "/U"))
	       wattroff(toprint->window, A_UNDERLINE);
	     else if(!strcasecmp(tag, "HTML"))
	       continue;
	     else if(!strcasecmp(tag, "/HTML"))
	       continue;
	     else if(!strcasecmp(tag, "BR"))
	       waddch(toprint->window, '\n');
	     else if(!strcasecmp(tag, "I"))
	       continue;
	     else if(!strcasecmp(tag, "/I"))
	       continue;
	     else if(!strcasecmp(tag, "/A"))
	       wprintw(toprint->window, "]");
	     else if(!strcasecmp(tag, "BLINK"))
	       wattron(toprint->window, A_BLINK);
	     else if(!strcasecmp(tag, "/BLINK"))
	       wattroff(toprint->window, A_BLINK);
	     else if(!strncasecmp(tag, "FONT", 4) || !strncasecmp(tag, "BODY", 4) || !strncasecmp(tag, "A", 1))
	       {
		  char *lvalue, *rvalue;
		  int curpos = 0, i;

		  lvalue = (char*)alloca(count);
		  rvalue = (char*)alloca(count);
		  if(lvalue == NULL || rvalue == NULL)
		    return;

		  for(i = (strchr(tag, ' ') - tag) + 1; i < count; i++)
		    {
		       lvalue_loop:
		       while(tag[i] != ' ' && tag[i] != '=' && tag[i])
			 {
			    if(tag[i] == '\"')
			      {
				 i++;
				 while(tag[i] != '\"')
				   lvalue[curpos++] = tag[i++];
				 break;
			      }

			    lvalue[curpos++] = tag[i++];
			 }

		       lvalue[curpos] = '\0';
		       if(lvalue[0] == '\0')
			 {
			    i++;
			    curpos = 0;
			    goto lvalue_loop;
			 }
		       curpos = 0;

		       rvalue_loop:
		       while(tag[i] != ' ' && tag[i] != '=' && tag[i])
			 {
			    if(tag[i] == '\"')
			      {
				 i++;
				 while(tag[i] != '\"')
				   rvalue[curpos++] = tag[i++];
				 break;
			      }

			    rvalue[curpos++] = tag[i++];
			 }

		       rvalue[curpos] = '\0';
		       if(rvalue[0] == '\0')
			 {
			    i++;
			    curpos = 0;
			    goto rvalue_loop;
			 }
		       curpos = 0;

		       if(!strncasecmp(lvalue, "COLOR", 5) || !strncasecmp(lvalue, "BODY", 4) || !strncasecmp(lvalue, "BGCOLOR", 7))
			 {
			    unsigned char c[3][3] = {{0}};
			    int r, g, b, i = 0, j = 0, k = 0;
			    int *color = &fore_color;

			    if(!strncasecmp(lvalue, "COLOR", 5))
			      color = &fore_color;
			    else if(!strncasecmp(lvalue, "BODY", 4) || !strncasecmp(lvalue, "BGCOLOR", 7))
			      color = &back_color;

			    while(rvalue[k] && i <= 2)
			      {
				 if(isxdigit(rvalue[k]))
				   c[i][j++] = rvalue[k];

				 if(j > 1)
				   {
				      j = 0;
				      i++;
				   }
				 k++;
			      }

			    r = strtol(c[0], NULL, 16);
			    g = strtol(c[1], NULL, 16);
			    b = strtol(c[2], NULL, 16);

			    /* logic needs to be fixed... works in many cases though */
			    if(r < 30 && g < 30 && b < 30) /* black */
			      *color = COLOR_BLACK;
			    else if(r > b && r > g) /* red */
			      *color = COLOR_RED;
			    else if(r < g && b < g) /* green */
			      *color = COLOR_GREEN;
			    else if(r > 200 && g > 200 && b < r && b < g) /* yellow */
			      *color = COLOR_YELLOW;
			    else if(r < b && g < b && abs(b-g) > 50) /* make color blue */
			      *color = COLOR_BLUE;
			    else if(r > g && b > g && abs(r-b) < 20) /* magenta */
			      *color = COLOR_MAGENTA;
			    else if(r < g && r < b && abs(b-g) < 50) /* make cyan */
			      *color = COLOR_CYAN;
			    else if(r > 220 && g > 220 && b > 220) /* make white */
			      *color = COLOR_WHITE;

			    push_colors(color_list, fore_color, back_color);
			    wattron(toprint->window, CP(fore_color, back_color) );
			 }
		       else if(!strncasecmp(lvalue, "HREF", 4))
			 {
			    wprintw(toprint->window, "URL:%s [", rvalue);
			 }
		    }
	       }

	     else if(!strcasecmp(tag, "/FONT") || !strcasecmp(tag, "/BODY"))
	       {
		  color_node popped_colors = pop_colors(color_list);
		  popped_colors = peek_colors(color_list);

		  fore_color = popped_colors.foreground;
		  back_color = popped_colors.background;

		  wattron(toprint->window, CP(fore_color, back_color) );
	       }
	     else
	       {
		  in_trouble = TRUE;
		  i = orig_i_pos - 1;
	       }
	  }
	else
	  {
	     attr_t attr;
	     void *blah;
	     short asdf;

	     if(fore_color == back_color)
	       {
		  wattr_get(toprint->window, &attr, &asdf, blah);
		  if(attr & A_BOLD )
		    {
		       if(html[i-1] == ' ')
			 {
			    int wordlength = currentwordlength(html, i);
			    int lengthtoend = (toprint->window->_maxx - toprint->window->_curx);

			    if(wordlength > lengthtoend && wordlength > 5 && lengthtoend > 3 && putdash == FALSE)
			      {
				 putdash = TRUE;
				 dashcount = lengthtoend + 1;
			      }
			    else
			      {
				 if(wordlength > lengthtoend)
				   waddch(toprint->window, '\n');
			      }

			 }

		       if(putdash == TRUE)
			 {
			    dashcount--;
			    if(dashcount == 0)
			      {
				 waddch(toprint->window, '-');
				 putdash = FALSE;
			      }
			 }

		       waddch(toprint->window, html[i]);
		    }
		  else
		    {
		       wattron(toprint->window, A_BOLD);
		       if(html[i-1] == ' ')
			 {
			    int wordlength = currentwordlength(html, i);
			    int lengthtoend = (toprint->window->_maxx - toprint->window->_curx);

			    if(wordlength > lengthtoend && wordlength > 5 && lengthtoend > 3 && putdash == FALSE)
			      {
				 putdash = TRUE;
				 dashcount = lengthtoend + 1;
			      }
			    else
			      {
				 if(wordlength > lengthtoend)
				   waddch(toprint->window, '\n');
			      }

			 }

		       if(putdash == TRUE)
			 {
			    dashcount--;
			    if(dashcount == 0)
			      {
				 waddch(toprint->window, '-');
				 putdash = FALSE;
			      }
			 }

		       waddch(toprint->window, html[i]);
		       wattroff(toprint->window, A_BOLD);
		    }
	       }
	     else
	       {
		  if(html[i-1] == ' ')
		    {
		       int wordlength = currentwordlength(html, i);
		       int lengthtoend = (toprint->window->_maxx - toprint->window->_curx);

		       if(wordlength > lengthtoend && wordlength > 5 && lengthtoend > 3 && putdash == FALSE)
			 {
			    putdash = TRUE;
			    dashcount = lengthtoend + 1;
			 }
		       else
			 {
			    if(wordlength > lengthtoend)
			      waddch(toprint->window, '\n');
			 }
		    }

		  if(putdash == TRUE)
		    {
		       dashcount--;
		       if(dashcount == 0)
			 {
			    waddch(toprint->window, '-');
			    putdash = FALSE;
			 }
		    }

		  waddch(toprint->window, html[i]);
	       }
	  }
     }

   while(color_list->next)
     pop_colors(color_list);
   FREE(color_list, "print_html");

   wattrset(toprint->window, CP(COLOR_WHITE, COLOR_BLACK));
}

int currentwordlength(char *string, int pos)
{
   int start = 0, stop;
   int i;

   for(i = 0; i < pos; i++)
     {
	if(string[i] == ' ')
	  start = i;
     }

   while(string[i] != ' ' && string[i++]);
   stop = i - 1;

   return stop - start - 1;
}

