/* Copyright (C) (2001) (Antonio SJ Musumeci) <bile_@hotmail.com>
  
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2 
   of the License, or (at your option) any later version.
  
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
  
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include "ntaim.h"

extern void *handle;
extern WINDOW *chat_win;
extern char username[];
extern char ntaim_path[];

buddylist_node *buddylist_head = NULL;
buddylist_node *buddylist_tail = NULL;
buddylist_node *scrolled_buddy = NULL;

int addbuddytolist(buddylist_node toadd)
{
   buddylist_node *current = buddylist_head;

   if(buddylist_head == NULL)
     {
	buddylist_head = (buddylist_node*) MALLOC(sizeof(buddylist_node), "addbuddytolist");
	if(buddylist_head == NULL)
	  {
	     alert("error when allocating memory for buddy list head.");
	     return -1;
	  }
	memcpy(buddylist_head, &toadd, sizeof(buddylist_node));
	strcpy(buddylist_head->stripedname, stripname(toadd.screenname));
	buddylist_head->next = NULL;
	buddylist_head->prev = NULL;
	buddylist_tail = buddylist_head;
	return 0;
     }
   else
     {
	buddylist_node *tmp = findbuddybyscreenname(toadd.screenname);
	int roomregistered = 0;
	
	if(tmp && toadd.isroom == 0)
	  return 0;
	
	while(current->next)
	  {
	     if(current->isroom && !strcmp(toadd.screenname, current->screenname))
	       roomregistered = 1;
	     current = current->next;
	  }
	
	if(roomregistered)
	  return 0;
	  
	current->next = (buddylist_node*) MALLOC(sizeof(buddylist_node), "addbuddytolist");
	if(current->next == NULL)
	  {
	     alert("error when allocating memory for buddy list node.");
	     return -1;
	  }
	memcpy(current->next, &toadd, sizeof(buddylist_node));
	strcpy(current->next->stripedname, stripname(toadd.screenname));
	current->next->next = NULL;
	current->next->prev = current;
	buddylist_tail = current->next;
	return 0;
     }
   return -1;
}

int removebuddyfromlist(const char * const screenname)
{
   buddylist_node *current = buddylist_head;

   while(current)
     {
	if(!strcmp(current->stripedname, stripname((char*)screenname)))
	  {
	     if(current == buddylist_tail)
	       {
		  if(buddylist_tail->prev)
		    buddylist_tail = buddylist_tail->prev;
		  else
		    buddylist_tail = NULL;
	       }

	     if(current->next)
	       current->next->prev = current->prev;

	     if(current->prev)
	       current->prev->next = current->next;

	     if(current == buddylist_head)
	       {
		  if(current->next)
		    buddylist_head = current->next;
		  else
		    buddylist_head = NULL;
	       }

	     if(scrolled_buddy == current)
	       {
		  if(scrolled_buddy->next)
		    scrolled_buddy = scrolled_buddy->next;
		  else if(scrolled_buddy->prev)
		    scrolled_buddy = scrolled_buddy->prev;
		  else
		    scrolled_buddy = NULL;

		  if(scrolled_buddy)
		    {
		       werase(chat_win);
		       if(scrolled_buddy->buddy_alias[0])
			 mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->buddy_alias);
		       else
			 mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->screenname);
		       wrefresh(chat_win);
		    }
		  else
		    {
		       werase(chat_win);
		       wrefresh(chat_win);
		    }
	       }
	     FREE(current, "removebuddyfromlist");
	     current = NULL;
	     return 0;
	  }
	current = current->next;
     }
   return -1;
}

int removeroomfromlist(const char * const room)
{
   buddylist_node *current = buddylist_head;

   while(current)
     {
	if(!strcmp(current->stripedname, stripname((char*)room)) && current->isroom)
	  {
	     if(current == buddylist_tail)
	       {
		  if(buddylist_tail->prev)
		    buddylist_tail = buddylist_tail->prev;
		  else
		    buddylist_tail = NULL;
	       }

	     if(current->next)
	       current->next->prev = current->prev;

	     if(current->prev)
	       current->prev->next = current->next;

	     if(current == buddylist_head)
	       {
		  if(current->next)
		    buddylist_head = current->next;
		  else
		    buddylist_head = NULL;
	       }

	     if(scrolled_buddy == current)
	       {
		  if(scrolled_buddy->next)
		    scrolled_buddy = scrolled_buddy->next;
		  else if(scrolled_buddy->prev)
		    scrolled_buddy = scrolled_buddy->prev;
		  else
		    scrolled_buddy = NULL;

		  if(scrolled_buddy)
		    {
		       werase(chat_win);
		       if(scrolled_buddy->buddy_alias[0])
			 mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->buddy_alias);
		       else
			 mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->screenname);
		       wrefresh(chat_win);
		    }
		  else
		    {
		       werase(chat_win);
		       wrefresh(chat_win);
		    }
	       }
	     FREE(current, "removebuddyfromlist");
	     current = NULL;
	     return 0;
	  }
	current = current->next;
     }
   return -1;
}

/* scrolls through your buddies, to the left or to the right */
void scroll_buddies(char *input_string, int currpos, unsigned short action)
{
   if (buddylist_head == NULL)
     return;

   if (scrolled_buddy == NULL)
     scrolled_buddy = buddylist_head;

   switch(action)
     {
      case SCROLLLEFT:
	scrollleft:
	if(scrolled_buddy->prev)
	  {
	     scrolled_buddy = scrolled_buddy->prev;
	     if(scrolled_buddy->online == FALSE)
	       goto scrollleft;
	  }
	else
	  {
	     scrolled_buddy = buddylist_tail;
	     if(scrolled_buddy->online == FALSE)
	       goto scrollleft;
	  }
	break;

      case SCROLLRIGHT:
	scrollright:
	if(scrolled_buddy->next)
	  {
	     scrolled_buddy = scrolled_buddy->next;
	     if(scrolled_buddy->online == FALSE)
	       goto scrollright;
	  }
	else
	  {
	     scrolled_buddy = buddylist_head;
	     if(scrolled_buddy->online == FALSE)
	       goto scrollright;
	  }
	break;
     }

   werase(chat_win);
   if(currpos)
     {
	input_string[currpos] = '\0';
	if(scrolled_buddy->buddy_alias[0])
	  mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->buddy_alias, input_string);
	else
	  mvwprintw(chat_win, 0, 0, "[%s] %s", scrolled_buddy->screenname, input_string);
     }
   else
     {
	if(scrolled_buddy->buddy_alias[0])
	  mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->buddy_alias);
	else
	  mvwprintw(chat_win, 0, 0, "[%s] ", scrolled_buddy->screenname);
     }

   if(!strcmp(getenv("TERM"), "xterm") || !strcmp(getenv("TERM"), "rxvt"))
     {
	if(scrolled_buddy->buddy_alias[0])
	  printf("\e]2;%s\a", scrolled_buddy->buddy_alias);
	else
	  printf("\e]2;%s\a", scrolled_buddy->screenname);
     }

   wrefresh(chat_win);
   return;
}

void clearbuddylist(void)
{
   buddylist_node *current_buddy = buddylist_head;

   while(current_buddy)
     {
	removebuddyfromlist(current_buddy->screenname);
	current_buddy = buddylist_head;
     }
   
   buddylist_head = NULL;
}

buddylist_node *findbuddybyscreenname(char *screenname)
{
   char *stripedname = stripname(screenname);
   buddylist_node *cur = buddylist_head;
   
   while(cur)
     {
	if(!strcmp(stripedname, cur->stripedname))
	  return cur;
	cur = cur->next;
     }
   return NULL;
}

buddylist_node *findbuddybybuddy_alias(char *buddy_alias)
{
   buddylist_node *cur = buddylist_head;

   while(cur)
     {
	if(!strcmp(buddy_alias, cur->buddy_alias))
	  return cur;
	cur = cur->next;
     }
   return NULL;
}

void savebuddylist(void)
{
   int fd;
   char path[PATHSIZE];
   buddylist_node *cur = buddylist_head;

   strcpy(path, ntaim_path);
   strcat(path, "/");
   strcat(path, username);
   strcat(path, ".buddylist");

   fd = open(path, O_WRONLY|O_CREAT, 0644);
   if(fd < 0)
     {
	alert("Failure when attempting to save buddy list!");
	return;
     }

   firetalk_im_list_buddies(handle);
   while(cur)
     {
	if(cur->isroom == FALSE)
	  {
	     write(fd, cur->screenname, strlen(cur->screenname));
	     write(fd, "\n", 1);
	  }

	cur = cur->next;
     }

   close(fd);
   info("Saved buddy list successfully.");
}

