#include "ntaim.h"

extern awaymessage_node *away_message;
extern void *handle;
extern window_node *current_window;
extern preferences pref;
extern int away;

void catch_alarm(int sig)
{
   int success;
   char mesg[] = "away...";
   char *ptrtomesg;

   if(pref.away_timer && !away)
     {
	if(away_message)
	  {
	     success = firetalk_set_away(handle, away_message->message);
	     ptrtomesg = away_message->message;
	  }
	else
	  {
	     success = firetalk_set_away(handle, mesg);
	     ptrtomesg = mesg;
	  }

	if(success == FE_SUCCESS)
	  {
	     wprintw(current_window->window, "Now away: ");
	     print_html(current_window, ptrtomesg);
	     waddch(current_window->window, '\n');
	     wrefresh(current_window->window);
	     away = 1;
	  }
	else
	  alert("could not set away.");
     }
}

int should_send_away_message(char* who)
{
   time_t time_value;
   buddylist_node *buddy;
   
   buddy = findbuddybyscreenname(who);
   
   if(buddy == NULL)
     return 1;
   
   time_value = time(NULL);
   
   if( (time_value - buddy->when_last_awaymessage_sent) > 120 )
     {
	buddy->when_last_awaymessage_sent = time_value;
	return 1;
     }
   else
     return 0;
}
