#ifndef __SESSION_H_
#define __SESSION_H_

#include <netdb.h>
#include <pthread.h>

#include "ber.h"
#include "oidseq.h"
#include "snmpsock.h" 

#define SESSION_DEBUGSNMP_FLAG 0x1ul
#define SESSION_DISABLED_FLAG  0x2ul

#define NEEDNL_ENTRY 1
#define NEEDNL_LINE 0

enum SNMP_error_unrecoverable {SNMPERR_NoResponse, SNMPERR_SocketErr};

class SNMP_error_oid{
  char *oidstr;
public:
  SNMP_error_oid(const char* str);
  ~SNMP_error_oid();
  int operator==(const char* otherstr);
};

class SNMP_session {
  static char need_newline; 
  static SNMP_session *lastprint;
  static pthread_mutex_t lastprint_m;

  SNMP_socket *sock;

  char *community;
  hostent *he;
  int ipidx;
  char *hostname;

  OidSeq *do_req(Tags tag, OidSeq *oids);

  unsigned int flags;
  int debugfile;
public:
  static void end();

  SNMP_session *next;

  SNMP_session(SNMP_socket *sockp, char *host, const char *community=NULL);
  ~SNMP_session();

  /* these take one oid sequence and then return a new oidseq with
     the values filled in. The oidseq passed in will not be 
     touched and the oidseq that is returned will need to be 
     freed. There are two reasons for not filling in the original 
     oidseq. 1) it is more work. 2) that way you can use the
     same sequence to ask multiple hosts the same questions. */
  OidSeq *get(OidSeq *oids){return do_req(GET_REQ_TAG,oids);}
  OidSeq *get_next(OidSeq *oids){return do_req(GET_NEXT_TAG,oids);}
  inline OidSeq *set(OidSeq *oids){return do_req(SET_REQ_TAG,oids);}
  inline char *ConnHost(){return he->h_addr_list[ipidx];}
  inline char *Hostname(){return hostname;}

  void setDebug();
  void write_debug(CONST char *dirstr, BerSequence *packet);
  void write_debug_bin(unsigned char *data, unsigned len);

  void printstr(unsigned long *argflags,char need_newline,char *str);
};

#endif
