/*
  outgoing.c

  $Id: outgoing.c,v 1.7 2003/07/23 09:31:01 bears Exp $
*/

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <dirent.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>

#if TIME_WITH_SYS_TIME
#include <sys/time.h>
#include <time.h>
#else
#if HAVE_SYS_TIME_H
#include <sys/time.h>
#else
#include <time.h>
#endif
#endif

#include <unistd.h>
#include "configfile.h"
#include "log.h"
#include "outgoing.h"
#include "util.h"
#include "portable.h"

struct Outgoing
{
    DIR *dir;
    Str serv;
} outgoing = { NULL, "" };

static void
fileOutgoing( Str file, const char *serv, const char *msgId )
{
    snprintf( file, MAXCHAR, "%s/outgoing/%s/%s",
              Cfg_spoolDir(), serv, msgId );
}

Bool
Out_add( const char *serv, const char *msgId, const DynStr *artTxt )
{
    Str outDir;

    Utl_cpyStr( outDir, Cfg_spoolDir() );
    Utl_catStr( outDir, "/outgoing" );

    return Utl_writeFile( outDir, serv, msgId, DynStr_str( artTxt ) );
}

Bool
Out_first( const char *serv, Str msgId, DynStr *artTxt )
{
    Str file;
    
    snprintf( file, MAXCHAR, "%s/outgoing/%s", Cfg_spoolDir(), serv );
    if ( ! ( outgoing.dir = opendir( file ) ) )
    {
        Log_dbg( LOG_DBG_NEWSBASE, "Cannot open %s", file );
        return FALSE;
    }
    Utl_cpyStr( outgoing.serv, serv );
    return Out_next( msgId, artTxt );
}

Bool
Out_next( Str msgId, DynStr *artTxt )
{
    struct dirent *d;
    FILE *f;
    Str file, line;

    ASSERT( outgoing.dir );
    
    do {
	if ( ! ( d = readdir( outgoing.dir ) ) )
	{
	    closedir( outgoing.dir );
	    outgoing.dir = NULL;
	    return FALSE;
	}
    } while ( strcmp( d->d_name, "." ) == 0 ||
	      strcmp( d->d_name, ".." ) == 0 );
    
    if ( msgId != NULL )
    	Utl_cpyStr( msgId, d->d_name );
    if ( artTxt == NULL )
        return ( d->d_name != NULL );
    fileOutgoing( file, outgoing.serv, d->d_name );
    if ( ! ( f = fopen( file, "r" ) ) )
    {
        Log_err( "Cannot open %s for read", file );
        return FALSE;
    }
    DynStr_clear( artTxt );
    while ( fgets( line, MAXCHAR, f ) )
        DynStr_app( artTxt, line );
    fclose( f );
    return TRUE;
}

void
Out_remove( const char *serv, const char *msgId )
{
    Str file;

    fileOutgoing( file, serv, msgId );
    if ( unlink( file ) != 0 )
        Log_err( "Cannot remove %s", file );
}

Bool
Out_find( const char *msgId, Str server )
{
    Str servdir;
    DIR *d;
    struct dirent *entry;
    Bool res;
    
    
    snprintf( servdir, MAXCHAR, "%s/outgoing", Cfg_spoolDir() );
    if ( ! ( d = opendir( servdir ) ) )
    {
        Log_dbg( LOG_DBG_NEWSBASE, "Cannot open %s", servdir );
        return FALSE;
    }

    res = FALSE;
    while ( ! res && ( entry = readdir( d ) ) != NULL )
    {
	Str file;
	struct stat s;

	if ( strcmp( entry->d_name, "." ) == 0 ||
	     strcmp( entry->d_name, ".." ) == 0 )
	    continue;
	
	fileOutgoing( file, entry->d_name, msgId );
	if ( stat( file, &s ) == 0 )
	{
	    res = TRUE;
	    Utl_cpyStr( server, entry->d_name );
	}
    }

    closedir( d );
    return res;
}





