/*
  lock.h

  Opening/Closing of the various databases: article overview database,
  articla database, groups database, outgoing articles database, requests
  database. Handles global lock.

  $Id: lock.h,v 1.4 2001/01/25 13:38:31 bears Exp $
*/

#ifndef LOCK_H
#define LOCK_H

#if HAVE_CONFIG_H
#include <config.h>
#endif

#include "common.h"

enum LockRequestWait { LOCK_WAIT, LOCK_NOWAIT };

/* Open all databases and set global lock. */
Bool
Lock_openDatabases( void );

/* Close all databases and release global lock. */
void
Lock_closeDatabases( void );

/* Ensure all databases synced to disc. */
void
Lock_syncDatabases( void );

/* Check the global lock held. */
Bool
Lock_gotLock( void );

/* Get fetch lock. */
Bool
Lock_getFetchLock( enum LockRequestWait wait );

/* Release fetch lock. */
void
Lock_releaseFetchLock( void );

/* Check the fetch lock held. */
Bool
Lock_fetchLock( void );

#endif
