# -*- coding: utf-8 -*-
#
#  Copyright (C) 2001, 2002 by Tamito KAJIYAMA
#  Copyright (C) 2004-2013 by Shyouzou Sugitani <shy@users.sourceforge.jp>
#
#  This program is free software; you can redistribute it and/or modify it
#  under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.  It is distributed in the
#  hope that it will be useful, but WITHOUT ANY WARRANTY; without even the
#  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#  PURPOSE.  See the GNU General Public License for more details.
#

import random


def execute(s):
    buf = []
    i = 0
    j = len(s)
    while i < j:
        i, text = expand(s, i)
        buf.append(text)
    return ''.join(buf)

def expand(s, start):
    segments = []
    repeat_count = None
    validity = 0
    i = start
    j = len(s)
    buf = []
    while i < j:
        if s[i] == '\\':
            if i + 1 < j and s[i + 1] in ['(', '|', ')']:
                buf.append(s[i + 1])
            else:
                buf.append(s[i:i + 2])
            i += 2
        elif s[i] == '(':
            if validity == 0:
                segments.append(''.join(buf))
                buf = []
                i += 1
            else:
                i, text = expand(s, i)
                buf.append(text)
            validity = 1
        elif s[i] == '|' and validity > 0:
            segments.append(''.join(buf))
            buf = []
            i += 1
        elif s[i] == ')' and validity > 0:
            segments.append(''.join(buf))
            i += 1
            if i < j and s[i] in '123456789':
                repeat_count = int(s[i])
                i += 1
            validity = 2
            break
        else:
            buf.append(s[i])
            i += 1
    if validity == 2:
        expanded = random.choice(segments[1:])
        if repeat_count:
            expanded = expanded * random.randint(0, repeat_count)
        return i, segments[0] + expanded
    elif validity == 0:
        return j, ''.join(buf)
    else:
        return j, s[start:]

def test(verbose=0):
    for test, expected in [(r'a(1)b', ['a1b']),
                           (r'a(1|2)b', ['a1b', 'a2b']),
                           (r'a(1)2b', ['ab', 'a1b', 'a11b']),
                           (r'a(1|2)1b', ['ab', 'a1b', 'a2b']),
                           (r'(1|2)(a|b)', ['1a', '1b', '2a', '2b']),
                           (r'((1|2)|(a|b))', ['1', '2', 'a', 'b']),
                           (r'()', ['']),
                           (r'()2', ['']),
                           (r'a()b', ['ab']),
                           (r'a()2b', ['ab']),
                           (r'a\(1\|2\)b', ['a(1|2)b']),
                           (r'\((1|2)\)', ['(1)', '(2)']),
                           (r'\(1)', ['(1)']),
                           (r'a|b', ['a|b']),
                           # errornous cases
                           (r'(1', ['(1']),
                           (r'(1\)', ['(1\)']),
                           (r'(1|2', ['(1|2']),
                           (r'(1|2\)', ['(1|2\)']),
                           (r'(1|2)(a|b', ['1(a|b', '2(a|b']),
                           (r'((1|2)|(a|b)', ['((1|2)|(a|b)']),
                           ]:
        result = execute(test)
        if verbose:
            print repr(test), '=>', repr(result), '...',
        try:
            if expected is None:
                assert(result == test)
            else:
                assert(result in expected)
            if verbose:
                print  'OK'
        except AssertionError:
            if verbose:
                print  'NG'
            raise


if __name__ == '__main__':
    print 'testing...'
    for i in range(1000): test()
    test(1)
