/*
 *  Nikwi Deluxe
 *  Copyright (C) 2006  Kostas Michalopoulos
 *  
 *  A game by Kostas "Bad Sector" Michalopoulos
 *  email: badsector@slashstone.com
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
** Nikwi Engine - Menu screen
*/

#include "nikwi.h"

MenuScreen	*menuScreen = NULL;

MenuScreen::MenuScreen()
{
	background = loadImage("data/objects/title.ut");
	paused = loadImage("data/objects/paused.ut");
	pwdBack = loadImage("data/objects/pwd2.ut");
	pwdMode = false;
	dot = findSprite("dot");
	sprite = NULL;
	spriteState = NULL;
	opt = 0;
	a = 0;
	y = ty = 240;
}

MenuScreen::~MenuScreen()
{
	if (spriteState)
		delete spriteState;
	SDL_FreeSurface(pwdBack);
	SDL_FreeSurface(paused);
	SDL_FreeSurface(background);
}

void MenuScreen::enter()
{
	DoubleLinesTransition	*trans = new DoubleLinesTransition;
	trans->begin();
	draw();
	trans->play();
	delete trans;
}

void MenuScreen::timer()
{
	if (y != ty)
	{
		if (y > ty)
		{
			a = -3.14f;
			y -= 6;
			if (y < ty)
				y = ty;
		}
		else
		{
			a = 0;
			y += 6;
			if (y > ty)
				y = ty;
		}
	}
	else
		a += 0.3f;
	pausedShow++;
}

void MenuScreen::draw()
{
	if (SDL_BlitSurface(background, NULL, screen, NULL) != 0)
	{
		SDL_FreeSurface(background);
		background = loadImage("data/objects/title.ut");
		SDL_Delay(100);
		draw();
		return;
	}
	if (game->playing)
	{
		SDL_Rect	r;
		if (((pausedShow/20) % 4))
		{
			r.x = 160;
			r.y = 397;
			if (SDL_BlitSurface(paused, NULL, screen, &r) != 0)
			{
				SDL_FreeSurface(paused);
				paused = loadImage("data/objects/paused.ut");
				SDL_Delay(100);
				draw();
				return;
			}
		}
	}
	switch (opt)
	{
		case 0:
			ty = 240;
			break;
		case 1:
			ty = 274;
			break;
		case 2:
			ty = 308;
			break;
		case 3:
			ty = 342;
			break;
	}
	if (!sprite)
	{
		sprite = findSprite("candy1");
		spriteState = new SpriteState(sprite);
	}
	spriteState->mirror = false;
	spriteState->draw(200, y-3+sin(a)*2);
	spriteState->mirror = true;
	spriteState->draw(411, y-3+sin(a)*2);
	if (pwdMode)
	{
		SDL_Rect	r;
		int		x = 224;
		r.x = 129;
		r.y = 200;
		if (SDL_BlitSurface(pwdBack, NULL, screen, &r) != 0)
		{
			SDL_FreeSurface(pwdBack);
			pwdBack = loadImage("data/objects/pwd2.ut");
			SDL_Delay(100);
			draw();
			return;
		}
		for (int i=0;i<pwdLen;i++,x+=32)
			dot->frame[0]->draw(x, 270, false);
	}
}

void MenuScreen::handleEvent(SDL_Event &e)
{
	if (e.type != SDL_KEYDOWN)
		return;
		
	if (pwdMode)
	{
		if (e.key.keysym.sym >= SDLK_a && e.key.keysym.sym <= SDLK_z)
		{
			if (pwdLen == 6)
			{
				playSample(findSample(makeCode("slct")));
				return;
			}
			playSample(findSample(makeCode("tick")));
			pwd[pwdLen++] = 'a'+(e.key.keysym.sym-SDLK_a);
			return;
		}
		if (e.key.keysym.sym == SDLK_BACKSPACE)
		{
			if (!pwdLen)
			{
				playSample(findSample(makeCode("slct")));
				return;
			}
			playSample(findSample(makeCode("tick")));
			pwdLen--;
			return;
		}
		if (e.key.keysym.sym == SDLK_RETURN)
		{
			playSample(findSample(makeCode("tick")));
			if (pwdLen == 6)
			{
				pwd[6] = 0;
				game->newGame(pwd);
				e.key.keysym.sym = SDLK_a;
				game->activate();
			}
			pwdMode = false;
			return;
		}
		if (e.key.keysym.sym == SDLK_ESCAPE)
			pwdMode = false;
		return;
	}
	
	switch (e.key.keysym.sym)
	{
		case SDLK_DOWN:
			if (opt == 3)
				opt = 0;
			else
				opt++;
			playSample(findSample(makeCode("slct")));
			break;
		case SDLK_UP:
			if (opt)
				opt--;
			else
				opt = 3;
			playSample(findSample(makeCode("slct")));
			break;
		case SDLK_SPACE:
		case SDLK_RETURN:
		{
			playSample(findSample(makeCode("tick")));
			switch (opt)
			{
				case 0:
					game->newGame(); 
					game->activate();
					break;
				case 1:
					pwdLen = 0;
					pwdMode = true;
					break;
				case 2:
					imageScreen->showImage(this,
						"data/objects/credits.ut");
					break;
				case 3:
					running = false;
					break;
			}
			break;
		}
		case SDLK_ESCAPE:
			if (game->playing)
				game->activate();
			break;
		default:;
	}
}

