/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.util;

import java.io.File;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.jar.JarFile;

public class System {
    private static final String home = java.lang.System.getProperty("user.home");
    private static final int homeLength = home.length();
    private static final DateFormat longDate = DateFormat.getDateTimeInstance();

    public static String prettyPrint(File f) {
        return System.prettyPrintFile(f.toString());
    }

    public static String prettyPrint(JarFile f) {
        return System.prettyPrintFile(f.getName());
    }

    public static String prettyPrintFile(String name) {
        if (name != null && name.startsWith(home)) {
            return "~" + name.substring(homeLength);
        }
        return name;
    }

    public static File getFile(String file) {
        if (file.charAt(0) == '~') {
            file = home + file.substring(1);
        }
        return new File(file);
    }

    public static String date(long date) {
        return longDate.format(new Date(date));
    }

    public static String[] split(String str, char separator) {
        ArrayList<String> res = new ArrayList<String>();
        int ntx = 0;
        int pos = 0;
        while (ntx > -1) {
            ntx = str.indexOf(separator, pos);
            if (ntx > -1) {
                if (ntx > 0) {
                    res.add(str.substring(pos, ntx));
                }
                pos = ntx + 1;
                continue;
            }
            res.add(pos == 0 ? str : str.substring(pos));
        }
        return res.toArray(new String[res.size()]);
    }
}

