/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.testsuite.output;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.io.Writer;
import nice.tools.testsuite.output.Output;
import nice.tools.testsuite.output.OutputWriter;

public abstract class AbstractOutput
implements Output {
    private OutputWriter _writer;

    public AbstractOutput(Writer out) {
        this._writer = new OutputWriter(out);
    }

    private void write(String str) {
        try {
            this._writer.write(str);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void mark() {
        this._writer.mark();
    }

    protected void reset() {
        this._writer.reset();
    }

    @Override
    public void close() {
        try {
            this._writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void flush() {
        try {
            this._writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void log(String statement) {
        this.log(null, statement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void log(String prefix, String statement) {
        if (statement.length() == 0) {
            this.write(this.getIndent());
            this.write((prefix == null ? "" : "[" + prefix + "] ") + statement + this.getLineBreak());
            return;
        }
        BufferedReader reader = null;
        String line = "";
        try {
            reader = new BufferedReader(new StringReader(statement));
            while ((line = reader.readLine()) != null) {
                this.write(this.getIndent());
                this.write((prefix == null ? "" : "[" + prefix + "] ") + line + this.getLineBreak());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void logAndFlush(String statement) {
        this.log(null, statement);
        this.flush();
    }

    @Override
    public void logAndFlush(String prefix, String statement) {
        this.log(prefix, statement);
        this.flush();
    }

    protected String getLineBreak() {
        return "\n";
    }

    protected String getIndent() {
        return "";
    }
}

