/*
 * Decompiled with CFR 0.152.
 */
package mlsub.typing;

import mlsub.typing.InternalError;
import mlsub.typing.Monotype;
import mlsub.typing.MonotypeVar;
import mlsub.typing.TupleType;
import mlsub.typing.Typing;
import mlsub.typing.lowlevel.Element;
import mlsub.typing.lowlevel.Engine;
import mlsub.typing.lowlevel.Kind;
import mlsub.typing.lowlevel.Unsatisfiable;

public class TupleKind
implements Kind {
    private static final TupleKind[] tupleKinds = new TupleKind[200];
    int arity;

    public static TupleKind get(int arity) {
        if (tupleKinds[arity] == null) {
            TupleKind.tupleKinds[arity] = new TupleKind(arity);
        }
        return tupleKinds[arity];
    }

    private TupleKind(int arity) {
        this.arity = arity;
        Engine.getConstraint(this);
    }

    @Override
    public Monotype freshMonotype(boolean existential) {
        Element[] args = MonotypeVar.news(this.arity, existential);
        Typing.introduce(args);
        return new TupleType((Monotype[])args);
    }

    @Override
    public void register(Element e) {
    }

    @Override
    public void leq(Element e1, Element e2, boolean initial) throws Unsatisfiable {
        if (initial) {
            throw new InternalError("initial leq in TupleKind");
        }
        this.leq(e1, e2);
    }

    @Override
    public void leq(Element e1, Element e2) throws Unsatisfiable {
        TupleType t1 = this.tuple(e1);
        TupleType t2 = this.tuple(e2);
        Engine.leq(t1.types, t2.types);
    }

    private TupleType tuple(Element e) {
        try {
            return (TupleType)((Monotype)e).equivalent();
        }
        catch (ClassCastException ex) {
            throw new InternalError(e + " was expected to be a tuple type, it's a " + e.getClass());
        }
    }

    public String toString() {
        return "Tuple(" + this.arity + ")";
    }
}

