/*
 * Decompiled with CFR 0.152.
 */
package gnu.mapping;

import gnu.lists.CharSeq;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.lists.SimpleVector;
import gnu.lists.Strings;
import gnu.mapping.OutPort;
import gnu.mapping.Printable;
import java.io.CharArrayWriter;
import java.io.PrintWriter;
import java.io.Writer;

public class SFormat {
    public String format(Object obj) {
        CharArrayWriter wr = new CharArrayWriter();
        this.format(obj, new OutPort(wr));
        return wr.toString();
    }

    public StringBuffer format(Object obj, StringBuffer buffer) {
        CharArrayWriter wr = new CharArrayWriter();
        this.format(obj, new OutPort(wr));
        buffer.append(wr.toCharArray());
        return buffer;
    }

    public void format(Object obj, PrintWriter ps) {
        SFormat.print(obj, ps);
    }

    public static boolean printReadable(Writer ps) {
        return ps instanceof OutPort && ((OutPort)ps).printReadable;
    }

    public static void print(Object obj, PrintWriter ps) {
        if (obj instanceof Printable) {
            ((Printable)obj).print(ps);
        } else if (obj instanceof Boolean) {
            ps.print((Boolean)obj != false ? "#t" : "#f");
        } else if (obj == null) {
            ps.print("#!null");
        } else if (obj instanceof Object[]) {
            Object[] arr = (Object[])obj;
            ps.print('[');
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    ps.print(' ');
                }
                SFormat.print(arr[i], ps);
            }
            ps.print(']');
        } else if (obj instanceof LList) {
            ps.print('(');
            boolean first = true;
            while (obj instanceof Pair) {
                if (!first) {
                    ps.print(' ');
                }
                first = false;
                Pair pair = (Pair)obj;
                SFormat.print(pair.car, ps);
                obj = pair.cdr;
            }
            if (obj != LList.Empty) {
                ps.print(" . ");
                SFormat.print(obj, ps);
            }
            ps.print(')');
        } else if (obj instanceof CharSeq) {
            if (SFormat.printReadable(ps)) {
                Strings.printQuoted((CharSeq)obj, ps, 0);
            } else {
                ps.print(obj);
            }
        } else if (obj instanceof SimpleVector) {
            SimpleVector vec = (SimpleVector)obj;
            String tag = vec.getTag();
            int size = vec.size;
            ps.print('#');
            if (tag != null) {
                ps.print(tag);
            }
            ps.print('(');
            for (int i = 0; i < size; ++i) {
                if (i > 0) {
                    ps.print(' ');
                }
                SFormat.print(vec.get(i), ps);
            }
            ps.print(')');
        } else if (obj instanceof int[]) {
            int[] arr = (int[])obj;
            ps.print('[');
            for (int i = 0; i < arr.length; ++i) {
                if (i > 0) {
                    ps.print(' ');
                }
                ps.print(arr[i]);
            }
            ps.print(']');
        } else {
            ps.print(obj);
        }
    }
}

