/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.Interpreter;
import gnu.expr.Target;
import gnu.expr.Undefined;
import gnu.lists.FormatToConsumer;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Values;

public class QuoteExp
extends Expression {
    Object value;
    Type type = null;
    public static QuoteExp undefined_exp = new QuoteExp(Undefined.getInstance());
    public static QuoteExp voidExp = new QuoteExp(Values.empty);
    public static QuoteExp trueExp = new QuoteExp(Boolean.TRUE);
    public static QuoteExp falseExp = new QuoteExp(Boolean.FALSE);
    public static QuoteExp nullExp = new QuoteExp(null);

    public final Object getValue() {
        return this.value;
    }

    @Override
    public final Type getType() {
        if (this.type != null) {
            return this.type;
        }
        if (this.value == Values.empty) {
            return Type.void_type;
        }
        if (this.value == null) {
            return Type.nullType;
        }
        return Type.make(this.value.getClass());
    }

    public QuoteExp(Object val) {
        this.value = val;
    }

    public QuoteExp(Object val, Type type) {
        this(val);
        this.type = type;
    }

    @Override
    public Object eval(Environment env) {
        return this.value;
    }

    @Override
    public void compile(Compilation comp, Target target) {
        comp.compileConstant(this.value, target);
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkQuoteExp(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(Quote", ")", 2);
        out.writeSpaceLinear();
        FormatToConsumer saveFormat = out.objectFormat;
        try {
            out.objectFormat = Interpreter.getInterpreter().getFormat(true);
            out.print(this.value);
        }
        finally {
            out.objectFormat = saveFormat;
        }
        out.endLogicalBlock(")");
    }
}

