/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.CodeAttr;
import gnu.bytecode.Label;
import gnu.bytecode.Type;
import gnu.expr.Compilation;
import gnu.expr.ConditionalTarget;
import gnu.expr.ExitExp;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Interpreter;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.CallContext;
import gnu.mapping.Environment;
import gnu.mapping.OutPort;
import gnu.mapping.Values;

public class IfExp
extends Expression {
    Expression test;
    Expression then_clause;
    Expression else_clause;

    public IfExp(Expression i, Expression t, Expression e) {
        this.test = i;
        this.then_clause = t;
        this.else_clause = e;
    }

    public static Expression make(Expression i, Expression t, Expression e) {
        Interpreter interpreter = Interpreter.getInterpreter();
        if (i instanceof QuoteExp) {
            if (interpreter.isTrue(((QuoteExp)i).getValue())) {
                return t;
            }
            return e;
        }
        return new IfExp(i, t, e);
    }

    protected final Interpreter getInterpreter() {
        return Interpreter.defaultInterpreter;
    }

    @Override
    public Object eval(Environment env) throws Throwable {
        Interpreter interpreter = this.getInterpreter();
        if (interpreter.isTrue(this.test.eval(env))) {
            return this.then_clause.eval(env);
        }
        if (this.else_clause != null) {
            return this.else_clause.eval(env);
        }
        return interpreter.noValue();
    }

    @Override
    public void eval(Environment env, CallContext ctx) throws Throwable {
        Interpreter interpreter = this.getInterpreter();
        if (interpreter.isTrue(this.test.eval(env))) {
            this.then_clause.eval(env, ctx);
        } else if (this.else_clause != null) {
            this.else_clause.eval(env, ctx);
        }
    }

    @Override
    public void compile(Compilation comp, Target target) {
        IfExp.compile(this.test, this.then_clause, this.else_clause == null ? QuoteExp.voidExp : this.else_clause, comp, target);
    }

    public static void compile(Expression test2, Expression then_clause, Expression else_clause, Compilation comp, Target target) {
        Label trueLabel;
        boolean trueInherited;
        Label falseLabel;
        boolean falseInherited;
        Interpreter interpreter = comp.getInterpreter();
        CodeAttr code = comp.getCode();
        if (target instanceof ConditionalTarget && else_clause instanceof QuoteExp) {
            falseInherited = true;
            Object value = ((QuoteExp)else_clause).getValue();
            falseLabel = interpreter.isTrue(value) ? ((ConditionalTarget)target).ifTrue : ((ConditionalTarget)target).ifFalse;
        } else if (else_clause instanceof ExitExp && ((ExitExp)else_clause).result instanceof QuoteExp && ((ExitExp)else_clause).block.subTarget instanceof IgnoreTarget) {
            falseInherited = true;
            falseLabel = ((ExitExp)else_clause).block.exitLabel;
        } else {
            falseInherited = false;
            falseLabel = new Label(code);
        }
        if (test2 == then_clause && target instanceof ConditionalTarget && then_clause instanceof ReferenceExp) {
            trueInherited = true;
            trueLabel = ((ConditionalTarget)target).ifTrue;
        } else {
            trueInherited = false;
            trueLabel = new Label(code);
        }
        ConditionalTarget ctarget = new ConditionalTarget(trueLabel, falseLabel, interpreter);
        if (trueInherited) {
            ctarget.trueBranchComesFirst = false;
        }
        test2.compile(comp, ctarget);
        code.emitIfThen();
        if (!trueInherited) {
            trueLabel.define(code);
            then_clause.compileWithPosition(comp, target);
        }
        if (!falseInherited) {
            code.emitElse();
            falseLabel.define(code);
            if (else_clause == null) {
                comp.compileConstant(Values.empty, target);
            } else {
                else_clause.compileWithPosition(comp, target);
            }
        } else {
            code.setUnreachable();
        }
        code.emitFi();
    }

    @Override
    public Type getType() {
        Type thenType = this.then_clause.getType();
        Type elseType = this.else_clause.getType();
        Type res = thenType.isVoid() ? thenType : (elseType.isVoid() ? elseType : Type.lowestCommonSuperType(thenType, elseType));
        if (res == null) {
            throw new Error("Incompatible types in " + this + ": " + thenType + " and " + elseType);
        }
        return res;
    }

    @Override
    protected Expression walk(ExpWalker walker) {
        return walker.walkIfExp(this);
    }

    @Override
    protected void walkChildren(ExpWalker walker) {
        this.test = this.test.walk(walker);
        if (walker.exitValue == null) {
            this.then_clause = this.then_clause.walk(walker);
        }
        if (walker.exitValue == null) {
            this.else_clause = this.else_clause.walk(walker);
        }
    }

    @Override
    public void print(OutPort out) {
        out.startLogicalBlock("(If ", false, ")");
        out.setIndentation(-2, false);
        this.test.print(out);
        out.writeSpaceLinear();
        this.then_clause.print(out);
        if (this.else_clause != null) {
            out.writeSpaceLinear();
            this.else_clause.print(out);
        }
        out.endLogicalBlock(")");
    }
}

