/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.Keyword;
import gnu.mapping.CallContext;
import gnu.mapping.MethodProc;
import gnu.mapping.WrongType;

public class GenericProc
extends MethodProc {
    MethodProc[] methods;
    int count;
    int minArgs;
    int maxArgs;

    @Override
    public int numArgs() {
        return this.minArgs | this.maxArgs << 12;
    }

    public void add(MethodProc method) {
        if (this.methods == null) {
            this.methods = new MethodProc[8];
        } else if (this.count >= this.methods.length) {
            MethodProc[] copy2 = new MethodProc[2 * this.methods.length];
            System.arraycopy(this.methods, 0, copy2, 0, this.count);
            this.methods = copy2;
        }
        this.methods[this.count++] = method;
        int n = method.minArgs();
        if (n < this.minArgs) {
            this.minArgs = n;
        }
        if ((n = method.maxArgs()) == -1 || n > this.maxArgs) {
            this.maxArgs = n;
        }
    }

    @Override
    public Object applyN(Object[] args) throws Throwable {
        GenericProc.checkArgCount(this, args.length);
        MethodProc best = null;
        CallContext bestVars = null;
        CallContext vars = null;
        int i = this.count;
        while (--i >= 0) {
            MethodProc method = this.methods[i];
            if (vars == null) {
                vars = new CallContext();
            }
            if (method.match(vars, args) != 0) continue;
            if (best == null) {
                best = method;
                bestVars = vars;
                vars = null;
                continue;
            }
            if ((best = MethodProc.mostSpecific(best, method)) != method) continue;
            bestVars = vars;
            vars = null;
        }
        if (best == null) {
            throw new WrongType(this, -1, null);
        }
        return best.applyV(bestVars);
    }

    @Override
    public int isApplicable(Type[] args) {
        int best = -1;
        int i = this.count;
        while (--i >= 0) {
            MethodProc method = this.methods[i];
            int result = method.isApplicable(args);
            if (result == 1) {
                return 1;
            }
            if (result != 0) continue;
            best = 0;
        }
        return best;
    }

    @Override
    public int match(CallContext ctx, Object[] args) {
        if (this.count == 1) {
            return this.methods[0].match(ctx, args);
        }
        MethodProc best = null;
        CallContext vars = null;
        CallContext bestVars = null;
        int i = this.count;
        while (--i >= 0) {
            int code;
            MethodProc method = this.methods[i];
            if (vars == null) {
                vars = new CallContext();
            }
            if ((code = method.match(vars, args)) != 0) continue;
            if (best == null) {
                best = method;
                bestVars = vars;
                vars = null;
                continue;
            }
            if ((best = MethodProc.mostSpecific(best, method)) != method) continue;
            bestVars = vars;
            vars = null;
        }
        if (best != null) {
            ctx.value1 = best;
            ctx.value2 = bestVars;
            return 0;
        }
        return -1;
    }

    @Override
    public Object applyV(CallContext ctx) throws Throwable {
        return ((MethodProc)ctx.value1).applyV((CallContext)ctx.value2);
    }

    public static GenericProc make(Object[] args) {
        int alen = args.length;
        boolean mlen = false;
        GenericProc result = new GenericProc();
        for (int i = 0; i < alen; ++i) {
            Object arg = args[i];
            if (arg instanceof Keyword) {
                String name = ((Keyword)arg).getName();
                Object value = args[++i];
                if (name == "name") {
                    result.setName(value.toString());
                    continue;
                }
                if (name == "method") {
                    result.add((MethodProc)value);
                    continue;
                }
                result.setProperty(name, value);
                continue;
            }
            result.add((MethodProc)arg);
        }
        return result;
    }
}

