/*
 * Decompiled with CFR 0.152.
 */
package nice.tools.code;

import bossa.util.Internal;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LambdaExp;
import gnu.expr.MemberLambdaExp;
import gnu.expr.PrimProcedure;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.expr.ThisExp;
import gnu.mapping.Procedure;
import nice.lang.inline.BoolNotOp;
import nice.lang.inline.CompOp;
import nice.lang.inline.Instanceof;
import nice.lang.inline.ReferenceOp;
import nice.lang.inline.Return;
import nice.lang.inline.ShortCircuitOp;
import nice.tools.code.GetFieldProc;
import nice.tools.code.Inline;
import nice.tools.code.IsOfClassProc;
import nice.tools.code.Strings;

public class Gen {
    private static final Expression equals = new QuoteExp(new PrimProcedure(Type.pointer_type.getDeclaredMethod("equals", 1)));

    public static Expression instanceOfExp(Expression value, Type ct) {
        return Inline.inline(Instanceof.instance, value, new QuoteExp(ct));
    }

    public static Expression isOfClass(Expression value, Type ct, boolean possiblyNull) {
        return Inline.inline(new IsOfClassProc(ct, possiblyNull), value);
    }

    public static Expression isNullExp(Expression value) {
        return Inline.inline(ReferenceOp.create("=="), value, QuoteExp.nullExp);
    }

    public static Expression referenceEqualsExp(Expression value1, Expression value2) {
        return Inline.inline(ReferenceOp.create("=="), value1, value2);
    }

    public static Expression boolNotExp(Expression value) {
        return Inline.inline(BoolNotOp.instance, value);
    }

    public static Expression integerComparison(String kind, Expression value1, long value2) {
        char type = value1.getType().getSignature().charAt(0);
        if (type == 'J') {
            return Inline.inline(CompOp.create("l" + kind), value1, new QuoteExp(new Long(value2), Type.long_type));
        }
        if (type == 'B' || type == 'S' || type == 'I' || type == 'C') {
            return Inline.inline(CompOp.create("i" + kind), value1, new QuoteExp(new Long(value2), Type.int_type));
        }
        throw Internal.error("not an integer type");
    }

    public static Expression shortCircuitAnd(Expression value1, Expression value2) {
        if (value1 == QuoteExp.trueExp) {
            return value2;
        }
        if (value2 == QuoteExp.trueExp) {
            return value1;
        }
        return Inline.inline(ShortCircuitOp.create("&&"), value1, value2);
    }

    public static Expression stringEquals(String value1, Expression value2) {
        return new ApplyExp(equals, new Expression[]{new QuoteExp(value1, Type.string_type), value2});
    }

    public static LambdaExp createMemberMethod(String bytecodeName, Type receiver, Type[] argTypes, Type retType, Expression[] params) {
        Declaration thisDecl = new Declaration("this");
        MemberLambdaExp lexp = new MemberLambdaExp(thisDecl);
        bytecodeName = Strings.escape(bytecodeName);
        int arity = 1 + (argTypes == null ? 0 : argTypes.length);
        lexp.setReturnType(retType);
        lexp.setName(bytecodeName);
        lexp.min_args = lexp.max_args = arity - 1;
        lexp.forceGeneration();
        lexp.setCanCall(true);
        lexp.setClassMethod(true);
        for (int n = 0; n < arity; ++n) {
            Declaration d;
            boolean isThis = n == 0;
            String parameterName = "anonymous_" + n;
            if (isThis) {
                d = thisDecl;
                d.setType(receiver);
                params[n] = new ThisExp(d);
            } else {
                d = lexp.addDeclaration(parameterName);
                d.setType(argTypes[n - 1]);
                params[n] = new ReferenceExp(d);
            }
            d.noteValue(null);
            d.setCanRead(true);
            d.setCanWrite(true);
        }
        return lexp;
    }

    public static void setMethodBody(LambdaExp method, Expression body) {
        method.body = body;
    }

    public static LambdaExp dereference(Expression ref) {
        return (LambdaExp)((ReferenceExp)ref).getBinding().getValue();
    }

    public static Expression returnVoid() {
        return Inline.inline(Return.instance);
    }

    public static Expression returnValue(Expression value) {
        return Inline.inline(Return.instance, value);
    }

    public static void store(Compilation comp, Expression destination, Target target) {
        if (destination instanceof ReferenceExp) {
            ((ReferenceExp)destination).getBinding().compileStore(comp);
            return;
        }
        CodeAttr code = comp.getCode();
        ApplyExp apply = (ApplyExp)destination;
        GetFieldProc fieldProc = (GetFieldProc)((QuoteExp)apply.getFunction()).getValue();
        Field field = fieldProc.getField();
        apply.getArgs()[0].compile(comp, field.getDeclaringClass());
        code.emitSwap();
        code.emitPutField(field);
    }

    public static LambdaExp wrapInLambda(Procedure proc) {
        int numArgs = proc.minArgs();
        LambdaExp lambda2 = new LambdaExp();
        lambda2.min_args = lambda2.max_args = numArgs;
        Expression[] args = new Expression[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            Declaration decl = lambda2.addDeclaration("param__" + i, Type.pointer_type);
            args[i] = new ReferenceExp(decl);
        }
        lambda2.body = new ApplyExp(proc, args);
        return lambda2;
    }

    public static Expression superCall(Expression method, Expression[] args) {
        return new ApplyExp(method, args, true);
    }

    public static Expression superCaller(Method method) {
        return new QuoteExp(PrimProcedure.specialCall(method));
    }
}

