/*  VER 072  TAB P   $Id: history.c,v 1.19.2.1 2002/01/29 07:57:27 egil Exp $
 *  
 *  history database lookup
 *
 *  copyright 1996, 1997, 1998 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: history.c,v $
 *  Revision 1.19.2.1  2002/01/29 07:57:27  egil
 *  Fix for tagged hash
 *
 *  Revision 1.19  1999/04/08 10:56:13  src
 *
 *  Revision 1.18  1999/04/08 10:48:54  src
 *  Extendeddbz to configure
 *
 *  Revision 1.17  1999/04/08 10:19:37  src
 *  Check for extendeddbz in configure
 *
 *  Revision 1.16  1999/03/31 03:38:28  src
 *  Moved errno.h to common.h
 *
 *  Revision 1.15  1999/03/09 11:43:57  src
 *  Cosmetic fixes
 *
 *  Revision 1.14  1999/03/07 15:40:58  src
 *  Removed DBZ_VERSION from configuration
 *
 *  Revision 1.13  1999/03/07 14:58:18  src
 *  Read newsconfig supported. Storage API supported.
 *
 *  Revision 1.12  1999/03/05 11:20:42  src
 *  Delayed decision of dbz v3 vz. 6 to runtime.
 *
 *  Revision 1.11  1999/03/04 16:20:20  src
 *  Renamed dbz v3, fixed hostname in spool
 *
 *  Revision 1.10  1998/09/14 05:27:34  src
 *  Declared offset
 *
 *  Revision 1.9  1998/09/09 07:32:11  src
 *  Version 1.1
 *
 *  Revision 1.8  1998/09/03 02:49:30  src
 *  Fixed stuff detected by -Wall
 *
 *  Revision 1.7  1998/07/12 09:39:28  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "options.h"
#include "newsconfig.h"
#include "news.h"

#if WITH_HISTORY

#ifdef HAVE_LIBDBZ
    /* BUG: this is pretty archaic */
#  include <dbz.h>
#else
#  include "../dbz/dbz.h"
#endif

#include "../dbz/dbz-v3.h"

/* negative if error (or disabled) */
int hist_open = 0;

static int dbz_vers = 0;

/*
 *  look up history database
 *  will convert message ID to news character case conventions
 *  return true if found there
 */
int 
history_lookup(char *msgid)
{
    int result;

    if (hist_open <= 0) {
	if (hist_open == 0) {

	    /* determine dbz version */
	    if (dbz_vers == 0) {
		dbz_vers = dbz_version(cfg_history);
		/* BUG: what about errors? */
	    }

	    if (dbz_vers == 3) {
		/* regardless of HAVE_LIBDBZ */
		result = dbzv3_dbminit(cfg_history);
	    } else {
		result = dbzinit(cfg_history);
	    }
	    if (result == -1) {
		if (errno == EDOM)
		    log_msg(L_ERR,"database \"%s\" in wrong format",cfg_history);
		else 
		    log_msg(L_ERRno,"can't open database \"%s\"",cfg_history);
		hist_open = -1;
		return 0;
	    }
	    log_msg(L_DEBUGMORE,"history file %s opened",cfg_history);
	    hist_open = 1;
	} else {
	    /* history file failed before, so don't bother */
	    return 0;
	}
    } 

    /* 
     *  look up database 
     */
    if (dbz_vers == 3) {
	/*
	 *  dbz v.3
	 */
	dbzv3_datum key;
	dbzv3_datum val;
	char *p;
	int len = strlen(msgid);

	/* convert host name to lower case */
	if ((p = strchr(msgid,'@'))) {
	    while (*++p) *p = tolower(*p);
	}

	key.dptr = msgid;
	key.dsize = len+1;
	
	val = dbzv3_dbmfetch(key);
	if (!(val.dptr)) {
	    log_msg(L_DEBUGMORE,"msgid %s not in history",msgid);
	    return 0;
	}
    } else {
	/*
	 *  dbz v.6 et.al.
	 */
	HASH key = HashMessageID(msgid);
	OFFSET_T offset;
#  ifdef DO_TAGGED_HASH
	offset = dbzfetch(key);
	if (offset == 0) {
	    /*
	     *  fix from G. Paul Ziemba:
	     *  mark as not found in history
	     */
	    offset = -1;
	}
#  else
	idxrec ionevalue;
	idxrecext iextvalue;
	offset = 0;

	if (cfg_extendeddbz) {
	    if (!dbzfetch(key, &iextvalue))
		offset = -1;
	    /* offset = iextvalue.offset[HISTOFFSET]; */
	} else {
	    if (!dbzfetch(key, &ionevalue))
		offset = -1;
	    /* offset = ionevalue.offset; */
	}
#  endif
	if (offset < 0) {
	    log_msg(L_DEBUGMORE,"msgid %s not in history",msgid);
	    return 0;
	}
	log_msg(L_DEBUGMORE,"dbzver=6, msgid %s IS in history, off=%d",
							msgid, offset);
    }
    /* OK, we found it */
    return 1;
}

/*
 *  done with history database
 */
void 
history_done(void)
{
    if (hist_open > 0) {
	if (dbz_vers == 3) {
	    dbzv3_dbmclose();
	} else {
	    dbzclose();
	}
	hist_open = 0; 
    }
}

#else /* WITH_HISTORY */

int 
history_lookup(char *msgid) 
{   return 0; 
}
void 
history_done(void)
{ 
}
#endif
