/*  VER 022  TAB P   $Id: msgid.c,v 1.6 1999/03/07 14:58:18 src Exp $
 *
 *  handle the message IDs
 *  to ensure we don't read a message twice
 *
 *  copyright 1996, 1997 Egil Kvaleberg, egil@kvaleberg.no
 *  the GNU General Public License applies
 *
 *  $Log: msgid.c,v $
 *  Revision 1.6  1999/03/07 14:58:18  src
 *  Read newsconfig supported. Storage API supported.
 *
 *  Revision 1.5  1998/09/09 07:32:12  src
 *  Version 1.1
 *
 *  Revision 1.4  1998/07/12 09:39:29  src
 *  newsx version 1.0
 */

#include "common.h"
#include "proto.h"
#include "news.h"

/* 
 *  globals for message IDs
 */
typedef struct message_id {
    struct message_id *next;
    char name[1]; /* extend as required... */
} MESSAGE_ID;

#define MESSAGE_HASH 999
MESSAGE_ID *messageids[MESSAGE_HASH] = { 0 };

/*
 *  check if msgid is not seen before, adding
 *  it to the list if not
 */
int 
new_msgid(char *msgid)
{
    int n; 
    MESSAGE_ID *mp;
    int h = hashindex(msgid,MESSAGE_HASH);

    /* find it first.. */
    for (mp = messageids[h]; mp; mp = mp->next) {
	if (strcmp(mp->name,msgid)==0) {
	    log_msg(L_DEBUGMORE,"msgid %s fetched already",msgid);
	    return 0;
	}
    }

    /* add to list */
    n = sizeof(MESSAGE_ID) + strlen(msgid);
    mp = xmalloc(n);
    strcpy(mp->name,msgid);
    mp->next = messageids[h];
    messageids[h] = mp;

    /* new */
    return 1;
}

