/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/



// Entity_REPOSITORY.h: interface for the Entity_REPOSITORY class.
//
//////////////////////////////////////////////////////////////////////

#ifndef ENTITY_REPOSITORY_H
#define ENTITY_REPOSITORY_H


#include "Entity.h"
#include "Entity_REPOSITORY_ASN1.h"
#include "RepStore.h"

#include <map>
using namespace std;

/*!
	This class represents a Repository Entity
*/
class Entity_REPOSITORY : public Entity
{
public:
	void PrintInfo(FILE * out);
	Entity_REPOSITORY(ENTITY_CONSTRUCTOR_PARAMETERS);
	virtual ~Entity_REPOSITORY();

	bool Load();
	bool Create(const EntityCreationDatas & Params, AdminResponseBody & response);
	bool ParseAdminCommand(AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest);
	bool Upgrade(const char * Version);
	bool Init(const EntitySignatureResp & init_datas);

	/*! \brief This function returns the list of types of logs the entity generates.
	 *  \param cLogsType [OUT] The list.
	 */
	static void LogsTypeGet(mVector<unsigned long> & cLogsType);

	/*! \brief This function returns the list of types of ACL the entity handles.
	 *  \param acl_list [OUT] The list.
	 */
	static void GetACL_List(mVector<unsigned long> & acl_list);
private:
	bool PrepareConfToWrite();
	#define REP_ENTITY_OBJECTS_TABLE	"objects"

	#define REP_ENTITY_CREATE_1			"create table global_conf (id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, conf LONGBLOB NOT NULL);"
	#define REP_ENTITY_CREATE_2			"create table "REP_ENTITY_OBJECTS_TABLE" (id INT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY, object_PEM LONGBLOB NOT NULL, INDEX (id));"

	#define REP_ENTITY_INSERT_G_CONF		"REPLACE INTO global_conf (id, conf) VALUES (1, '%s');"
	#define REP_ENTITY_GET_G_CONF			"SELECT * FROM global_conf;"
	#define REP_ENTITY_DEL_G_CONF			"DELETE FROM global_conf;"
	#define REP_ENTITY_INSERT_OBJECT		"INSERT INTO "REP_ENTITY_OBJECTS_TABLE" (object_PEM) VALUES ('%s');"
	#define REP_ENTITY_GET_OBJECTS			"SELECT * FROM "REP_ENTITY_OBJECTS_TABLE" LIMIT 50;"
	#define REP_ENTITY_DEL_OBJECT			"DELETE FROM "REP_ENTITY_OBJECTS_TABLE" WHERE id='%ld';"


	bool OnNewPkiConf(const ExportedPkiConf & conf);
	bool IsKnownRepository(const PKI_CERT & Cert);

	bool OnNewObject(const WaitingNewpkiObject & object, int & Status);
	bool CreateWaitingObject(WaitingNewpkiObject & object, const CryptedNewpkiRequest & request, const CryptedNewpkiResponse & response, const Asn1OctetString & DeleteTid, const PKI_CERT & AddRep = PKI_CERT::EmptyInstance);
	bool CreateNewObject(const CryptedNewpkiRequest & request, const CryptedNewpkiResponse & response, const Asn1OctetString & DeleteTid, const PKI_CERT & AddRep = PKI_CERT::EmptyInstance);
	bool SynchronizeWithRepository(PkiClient * ClientPki, const RepEntryInfo & Repository);
	bool Conf_Flush();
	static bool Private_ParseAdminCommand(bool ExecuteCmd, Entity * me_this, mVector<unsigned long> &  mLogsType, AdminResponseBody & response, const PKI_CERT & ClientCert, const AdminRequest & AdminRequest, UserHandle & hUser);
	bool ParseSynchroObject(const ObjectsListSynchro & inObjects, ObjectsListSynchro & outObjects, bool & get_req, bool & get_resps, unsigned long & index_req, unsigned long & index_resp);

	bool DeleteResponse(COMMAND_PARAMETERS);
	bool SynchronizeObjects(COMMAND_PARAMETERS);
	bool PushConfiguration(COMMAND_PARAMETERS);
	bool PushWaitingObject(COMMAND_PARAMETERS);
	bool GetMyConf(COMMAND_PARAMETERS);
	bool GetMyRequests(COMMAND_PARAMETERS);
	bool GetMyResponses(COMMAND_PARAMETERS);
	bool ImportRequest(COMMAND_PARAMETERS);
	bool ImportResponse(COMMAND_PARAMETERS);
	bool GetConfiguration(COMMAND_PARAMETERS);
	
	bool ParseNewConf();

	static void ThreadCaObjectsPush(const NewpkiThread * Thread, void *param);
	bool InsertObject(const WaitingNewpkiObject & object);
	void GetObjects(mVector<WaitingNewpkiObject> & localObjects, mVector<unsigned long> & ids);
	void DeleteObjects(const mVector<unsigned long> & ids);

	
	bool LoginUser(UserHandle & hUser, int & UserType);
	void LogoutUser(const UserHandle & hUser);

	RepStore RepositoryStore;
	LocalRepositoryConf myConf;
	ExportedPkiConf pki_conf;
	NewpkiThread hThreadCaObjectsPush;
	
	DECLARE_COMMAND_PARSER(Entity_REPOSITORY);
};

#endif
