/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// AuthModule.cpp: implementation of the AuthModule class.
//
//////////////////////////////////////////////////////////////////////

#include "AuthModule.h"
#include <PKI_ERR.h>

//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

AuthModule::AuthModule(const mString & LibraryPath, const mString & LibraryCmd)
{
	hLib = NULL;

	m_LibraryCmd = LibraryCmd;
	hLib = DSO_load(NULL, LibraryPath.c_str(), DSO_METHOD_dl(), 0);
	if (!hLib)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_ABORT);
		throw ExceptionNewPKI();
	}

	GetFunctionsList = (GET_FUNCTIONS_LIST)DSO_bind_func(hLib, "GetFunctionsList");
	if(!GetFunctionsList)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_AUTH_LIB);
		if(hLib) DSO_free(hLib);
		throw ExceptionNewPKI();
	}

	FunctionsList = GetFunctionsList();
	if(!FunctionsList)
	{
		NEWPKIerr(PKI_ERROR_TXT, ERROR_BAD_AUTH_LIB);
		if(hLib) DSO_free(hLib);
		throw ExceptionNewPKI();
	}
}

AuthModule::~AuthModule()
{
	if(hLib) DSO_free(hLib);
}

bool AuthModule::Login(const char *username, const char *password)
{
	return (FunctionsList->login(m_LibraryCmd.c_str(), username, password) == 1);
}

bool AuthModule::ValidateUsername(const char *Username)
{
	return (FunctionsList->validate_username(m_LibraryCmd.c_str(), Username) == 1);
}
