/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// PkiUserCreation.h: interface for the PkiUserCreation class.
//
//////////////////////////////////////////////////////////////////////

#ifndef PKIUSERCREATION_H
#define PKIUSERCREATION_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif
#include <wx/window.h>


#ifdef _WIN32
	#include "PkiEnroll.h"
#endif
#include <ASN1/Asn1User.h>
#include <mString.h>

class PkiUserCreation  
{
public:
	void set_Parent(wxWindow * parent);
	PkiUserCreation();
	virtual ~PkiUserCreation();

	static void LoadProviders(wxComboBox * combo, const char * Default = NULL);
	bool import_Response(const CreatePkiUserResponse & response);
	void Cancel();
	bool generate_Request(CreatePkiUserRequest & request);
	void set_HardwareKey(int keylen, const mString & provider);
	void set_SoftwareKey(int keylen, const mString & password);
	void set_PublicKey(const X509_PUBKEY * pubkey);
	void set_Info(const mString &cn, const mString &email, int PkiAdmin);
private:
	typedef enum en_REQ_INTERNAL_TYPE
	{
		REQ_INTERNAL_TYPE_P12,
		REQ_INTERNAL_TYPE_SC,
		REQ_INTERNAL_TYPE_P7
	}REQ_INTERNAL_TYPE;

	REQ_INTERNAL_TYPE m_internaltype;
	bool import_SC(const PKI_P7B & p7b);
	bool import_PKCS7(const PKCS7 * p7b);
	bool import_PKCS12(const PKCS12 * p12);
	mString m_cn;
	mString m_email;
	int m_admin;
	mString m_password;
	int m_keylen;
	mString m_provider;
#ifdef _WIN32
	PkiEnroll m_enroll;
#endif
	X509_PUBKEY* m_pubkey;
	int m_type;
	wxWindow * m_parent;
};

#endif
