/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgPublishDN.h: interface for the DlgPublishDN class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGPUBLISHDN_H
#define DLGPUBLISHDN_H


#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <ASN1/Asn1Conf.h>
#include <stdio.h>
#include <Objects.h>
#include "Error.h"
#include <PkiClient.h>
#include "DlgMessage.h"
#include "DlgSearchLDAP.h"

#ifdef _WIN32
	#include "PkiEnroll.h"
#endif


#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/dialog.h>


class DlgPublishDNListCtrl: public wxListCtrl
{
public:
	DlgPublishDNListCtrl(wxWindow *parent, const wxWindowID id, const wxPoint& pos,
			const wxSize& size, long style):
		wxListCtrl(parent, id, pos, size, style)
		{
		}

	void OnItemClick(wxListEvent& event);
private:
	DECLARE_EVENT_TABLE()
};



/*!
	This class is in charge a creating a profile
*/
class DlgPublishDN: public wxDialog 
{
public:
	DlgPublishDN(wxWindow * wParent, const EntityConfBody & EntityConf, ASN1_BIT_STRING * my_acl, PkiClient * ClientPki, const X509_NAME * dn, unsigned long profile_id);
	virtual ~DlgPublishDN();

	void OnOk(wxCommandEvent& event);
	void OnCancel(wxCommandEvent &event);
	void OnSave(wxCommandEvent &event);
	void OnItemClick(wxListEvent& event);
	void OnSearchLDAP(wxCommandEvent& event);
	bool IsOk();

private:
	void InitList(const X509_NAME * dn);
	int GetNid(char * Obj);
	void ClearList();


	DlgMessage * Msg;
	
	bool m_IsOk;
	PkiClient * m_ClientPki;
	const EntityConfBody & m_EntityConf;
	class FIELD_INFO
	{
	public:
		mString Value;
		DnSpecs Specs;
	};

	const X509_NAME * m_dn;
	unsigned long m_profile_id;
	mVector<UsersGroup> m_groups;
	DlgPublishDNListCtrl * m_listCtrl;
	wxImageList *m_imageListSmall;

	DECLARE_EVENT_TABLE()
};

#endif
