 /*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgManageEntities.h: interface for the DlgManageEntities class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGMANAGEENTITIES_H
#define DLGMANAGEENTITIES_H

#ifdef _WIN32
#pragma warning(disable:4786)
#endif


#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/dialog.h>

#include <stdio.h>
#include <string.h>
#include "Error.h"
#include "Functions.h"
#include <PkiClient.h>
#include <ASN1/Asn1Entity.h>
#include <mString.h>

#include <map>
using namespace std;

#include "DlgGetLink.h"

class wxEntityInfoEvent:public wxEvent
{
public:
    wxEntityInfoEvent(const wxEntityInfoEvent& event):wxEvent(event)
	{
		m_info = event.m_info;
	}
	wxEntityInfoEvent():wxEvent()
	{
	}
	void SetEntityInfo(const EntityLinks & info)
	{
		m_info = info;
	}
	const EntityLinks & GetEntityInfo()
	{
		return m_info;
	}
	wxEvent *Clone() const
	{
		return new wxEntityInfoEvent(*this);
	}

private:
	EntityLinks m_info;
};




typedef struct st_OBJECT_POSITION
{
	int x;
	int y;
}OBJECT_POSITION;


#define ICON_WIDTH 45
#define ICON_HEIGHT 45

class myEntitiesCanvas: public wxScrolledWindow
{
public:
	myEntitiesCanvas();
    myEntitiesCanvas(wxWindow *parent,
                         wxWindowID id = -1,
                         const wxPoint& pos = wxDefaultPosition,
                         const wxSize& size = wxDefaultSize,
                         long style = wxScrolledWindowStyle,
                         const wxString& name = wxPanelNameStr);
	~myEntitiesCanvas();

	void PaintPicture(wxDC & dc);
	void SaveObjectsPos();
	void SetZoom(int zoom);
	void SetFontSize(int size);
	void SetOwner(wxDialog * owner);
	void SetLinks(const char * PkiName, mVector<EntityLinks> * links);
    void OnPaint(wxPaintEvent &event);
	void OnSrcCanAccess(wxCommandEvent &event);
	void OnDstCanAccess(wxCommandEvent &event);
	void OnMouseMove(wxMouseEvent &event);
	void OnMouseDownL(wxMouseEvent &event);
	void OnMouseDownR(wxMouseEvent &event);
	void OnMouseUp(wxMouseEvent &event);
	void OnAddLink(wxCommandEvent &event);
	void OnDelLink(wxCommandEvent &event);
	void OnSetRepsOrder(wxCommandEvent &event);
	int GetMaxHeight();
	int GetMaxWidth();
private:
	#define PKI_COLOR 0, 255, 0
	#define CA_COLOR 255, 0, 0
	#define KEY_COLOR 204, 255, 255
	#define EE_COLOR 255, 0, 255
	#define PUB_COLOR 204, 153, 255
	#define REP_COLOR 0, 0, 255
	#define LINK_WIDTH 3
	#define ANCHOR_RADIUS 5

	bool lineHitTest( int x1, int y1, int x2, int y2, int x, int y );
	bool SetSavedValue(char * OptionName, const char * Value);
	char * GetSavedValue(char * OptionName);
	void DrawObject(wxDC & dc, EntityLinks & Object, bool Selected, int & max_x, int & max_y);
	void DrawLinks(wxDC &dc);
	void GetLinksItems(EntityLinks & SrcEntry);
	void LoadObjectsPos();

	map<mString, OBJECT_POSITION> objects_position;

	mVector<EntityLinks> * m_links;
	wxDialog * m_owner;
	bool WasDragging;
	int m_drag_x;
	int m_drag_y;
	int last_max_x;
	int last_max_y;
	const char * m_PkiName;

	EntityLinks * MouseoverItem;
	EntityLinks * SelectedItem;

	mString RepSource;
	mString RepDest;
	bool RepSourceIsChecked;
	bool RepDestIsChecked;

	wxBitmap LogoPkiBig;
	wxBitmap LogoRepBig;
	wxBitmap LogoCaBig;
	wxBitmap LogoRaBig;
	wxBitmap LogoPubBig;
	wxBitmap LogoKeyBig;
	wxBitmap LogoEEBig;

	mVector<size_t> list_present;
	mVector<size_t> list_unpresent;
	wxBitmap hPicBg;

	DECLARE_DYNAMIC_CLASS(myEntitiesCanvas)
    DECLARE_EVENT_TABLE()
};


class DlgManageEntities: public wxDialog
{
public:
	DlgManageEntities(wxWindow * wParent, const char * PkiName, PkiClient * ClientPKI);
	virtual ~DlgManageEntities();
	void OnOk(wxCommandEvent& event);
	void OnCancel(wxCommandEvent& event);
	void OnSaveScreen(wxCommandEvent& event);
	void OnDisplayInfo(wxEntityInfoEvent &event);
private:
	#define NEWPKI_PATH		"SOFTWARE\\Newpki"
	#define ENV_OBJECTS_FILE "/.newpki/objects_"
	mVector<EntityLinks> m_links;
	bool m_OK;
	PkiClient * m_ClientPKI;
	myEntitiesCanvas * drawing;
	wxTextCtrl * display_info;

	DECLARE_EVENT_TABLE()
};

#endif
