/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgLogin.cpp: implementation of the DlgLogin class.
//
//////////////////////////////////////////////////////////////////////

#ifdef _WIN32
#pragma warning(disable:4786)
#endif

#include "DlgGetPassword.h"

#include "DlgLogin.h"
#include "dlgs_wdr.h"
#include "clintl.h"



//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgLogin, wxDialog)
    EVT_BUTTON(IDC_OK, DlgLogin::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgLogin::OnCancel)
    EVT_BUTTON(IDC_BROWSE_P12, DlgLogin::OnBrowsePKC12)
    EVT_RADIOBUTTON(IDC_TYPE_LOGIN, DlgLogin::OnLoginPassord)
    EVT_RADIOBUTTON(IDC_TYPE_MS_CERT, DlgLogin::OnMSCERT)
    EVT_RADIOBUTTON(IDC_TYPE_P12_CERT, DlgLogin::OnPKCS12)
END_EVENT_TABLE()

DlgLogin::DlgLogin(wxWindow * wParent):wxDialog(wParent, (wxWindowID)-1, _("NewPKI Login"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxCAPTION)
{
		IsOk = false;

#ifdef _WIN32
		hMy = CertOpenSystemStore(NULL, "MY");
#endif
		
		DlgLogin_SetWindow(this);

		LogInfos.CaName[0] = 0;
		LogInfos.p12_cert.Clear();
		LogInfos.Password[0] = 0;
		LogInfos.pCert = NULL;
		LogInfos.Port = 0;
		LogInfos.Server[0] = 0;
		LogInfos.Username[0] = 0;
	
		LoadConf();

		char Port[10];

		if(!LogInfos.Port)
			LogInfos.Port = 333;
		sprintf(Port, "%d", LogInfos.Port);

		((wxTextCtrl *)FindWindow(IDC_ENTITY))->SetFocus();
		((wxTextCtrl *)FindWindow(IDC_ENTITY))->SetValue(LogInfos.CaName);
		((wxTextCtrl *)FindWindow(IDC_USERNAME))->SetValue(LogInfos.Username);
		((wxTextCtrl *)FindWindow(IDC_SERVER))->SetValue(LogInfos.Server);
		((wxTextCtrl *)FindWindow(IDC_PORT))->SetValue(Port);

		CenterOnScreen();
		ShowModal();
}

DlgLogin::~DlgLogin()
{
#ifdef _WIN32
		if(hMy) CertCloseStore(hMy, 0);
#endif
}

bool DlgLogin::SetLoginValue(char * OptionName, const char * Value)
{
#ifdef _WIN32
		HKEY hk; 

		if (RegCreateKey(HKEY_CURRENT_USER, NEWPKI_PATH, &hk) != ERROR_SUCCESS)
		{
			return false;
		}

		
		if (RegSetValueEx(hk, OptionName, 0, REG_SZ, (PUCHAR)Value, strlen(Value)) != ERROR_SUCCESS)
		{
			RegCloseKey(hk);
			return false;
		}
		RegCloseKey(hk);
		return true;
#else
		return true;
#endif
}

char * DlgLogin::GetLoginValue(char * OptionName)
{
#ifdef _WIN32
	long lRet;
	HKEY KeyRet;
	
	DWORD KeyType;

	static unsigned char OutDatas[300];
	DWORD OutDatasLen;

	*OutDatas=0;
	
	

	lRet = RegOpenKey(HKEY_CURRENT_USER, NEWPKI_PATH, &KeyRet);
	if(lRet!=ERROR_SUCCESS)
	{
		return "";
	}

	OutDatasLen = sizeof(OutDatas);
	lRet = RegQueryValueEx(KeyRet,OptionName,0,&KeyType,OutDatas,&OutDatasLen);
	if(lRet!=ERROR_SUCCESS)
	{
		RegCloseKey(KeyRet);
		return "";
	}
	
	RegCloseKey(KeyRet);

	return (char*)OutDatas;
#else
	return "";
#endif
}

void DlgLogin::OnOk(wxCommandEvent& event)
{
	wxString ca_name;
	wxString username;
	wxString password;
	wxString server;
	wxString port;
	wxString filename;
	unsigned int wPort;

	ca_name = ((wxTextCtrl *)FindWindow(IDC_ENTITY))->GetValue();
	server = ((wxTextCtrl *)FindWindow(IDC_SERVER))->GetValue();
	port = ((wxTextCtrl *)FindWindow(IDC_PORT))->GetValue();
	if(!server.Len() || !port.Len())
	{
		return;
	}

	LogInfos.pCert = NULL;
	LogInfos.p12_cert.Clear();
	*LogInfos.Username=0;
	*LogInfos.Password=0;

	if(((wxRadioButton *)FindWindow(IDC_TYPE_LOGIN))->GetValue())
	{
		username = ((wxTextCtrl *)FindWindow(IDC_USERNAME))->GetValue();
		password = ((wxTextCtrl *)FindWindow(IDC_PASSWORD))->GetValue();
		if(!username.Len() || !password.Len())
		{
			return;
		}
		strcpy(LogInfos.Username, username.GetData());
		strcpy(LogInfos.Password, password.GetData());

	}
#ifdef _WIN32
	else if(((wxRadioButton *)FindWindow(IDC_TYPE_MS_CERT))->GetValue())
	{
		LogInfos.pCert = (PCCERT_CONTEXT)((wxComboBox *)FindWindow(IDC_LIST_CERT))->GetClientData(((wxComboBox *)FindWindow(IDC_LIST_CERT))->GetSelection());
		if(!LogInfos.pCert) return;
	}
#endif
	else if(((wxRadioButton *)FindWindow(IDC_TYPE_P12_CERT))->GetValue())
	{
		filename = ((wxTextCtrl *)FindWindow(IDC_P12_FILE))->GetValue();
		if(!filename.Len()) return;

		DlgGetPassword dlgpwd(_("Please enter the PKCS#12 password"), this);
		if(!dlgpwd.IsOK()) return;
		if(!p12.LoadFromFile((char*)filename.GetData(), dlgpwd.GetPassword().c_str()))
		{
			HandleErrorResult(NULL, this, 0);
			return;
		}

		LogInfos.p12_cert = p12.GetEndUserCert();
	}



	strcpy(LogInfos.CaName, ca_name.GetData());
	strcpy(LogInfos.Server, server.GetData());
	sscanf(port.GetData(), "%d", &wPort);
	LogInfos.Port=wPort;


	
	WriteConf();

	IsOk = true;
	Close(TRUE);
}

void DlgLogin::OnCancel(wxCommandEvent& event)
{
	IsOk = false;
	Close(TRUE);
}


bool DlgLogin::GetLoginInfo(LOGIN_INFO * LoginInfo)
{
	if(IsOk)
	{
		*LoginInfo = LogInfos;
		return true;
	}
	else
		return false;
}


void DlgLogin::LoadConf()
{
	wxCommandEvent event;

#ifdef _WIN32
	PCCERT_CONTEXT currCert;
	PCCERT_CONTEXT dupCert;
	char dn[200];
	char * certname;
	int Index;
	int selectedIndex;
	char * Type;
	char * p12file;


	char * Port;
	strcpy(LogInfos.Username, GetLoginValue(ENV_PKI_USER));
	strcpy(LogInfos.Server, GetLoginValue(ENV_PKI_SERVER));
	strcpy(LogInfos.CaName, GetLoginValue(ENV_PKI_CA));

	Port = GetLoginValue(ENV_PKI_PORT);
	sscanf(Port, "%d", &LogInfos.Port);

	Type = GetLoginValue(ENV_PKI_TYPE);
	switch(*Type)
	{
		case '1':
			((wxRadioButton *)FindWindow(IDC_TYPE_LOGIN))->SetValue(true);
			OnLoginPassord(event);
			break;
		case '2':
			((wxRadioButton *)FindWindow(IDC_TYPE_MS_CERT))->SetValue(true);
			OnMSCERT(event);
			break;
		case '3':
			p12file = GetLoginValue(ENV_PKI_P12FILE);
			((wxTextCtrl *)FindWindow(IDC_P12_FILE))->SetValue(p12file);
			((wxRadioButton *)FindWindow(IDC_TYPE_P12_CERT))->SetValue(true);
			OnPKCS12(event);
			break;
		default:
			((wxRadioButton *)FindWindow(IDC_TYPE_LOGIN))->SetValue(true);
			OnLoginPassord(event);
			break;
	}

	
	if(hMy)
	{
		selectedIndex = 0;
		certname = GetLoginValue(ENV_PKI_CERTNAME);
		currCert = NULL;
		while( (currCert = CertEnumCertificatesInStore(hMy, currCert)) )
		{
			dupCert = CertDuplicateCertificateContext(currCert);
			if(!dupCert) continue;

			CertGetNameString(dupCert, CERT_NAME_SIMPLE_DISPLAY_TYPE, 0, NULL, dn, sizeof(dn));
			Index = ((wxComboBox *)FindWindow(IDC_LIST_CERT))->Append(dn, (void*)dupCert);
			if(strcmp(dn, certname) == 0)
			{
				selectedIndex = Index;
			}
		}
	}
	if(((wxComboBox *)FindWindow(IDC_LIST_CERT))->GetCount())
	{
		((wxComboBox *)FindWindow(IDC_LIST_CERT))->SetSelection(selectedIndex);
	}
	else
	{
		((wxRadioButton *)FindWindow(IDC_TYPE_MS_CERT))->Enable(FALSE);
		((wxComboBox *)FindWindow(IDC_LIST_CERT))->Enable(FALSE);
	}

#else
	char buffer[500];
	char * Value;
	char * path = getenv("HOME");
	if(!path) return;
	sprintf(buffer, "%s%s", path, ENV_PKI_FILE);
	char Type = 0;
	char p12file[PATH_MAX];



	FILE * fd = fopen(buffer, "r");
	if(!fd) return;

	while(!feof(fd))
	{
		if(!fgets(buffer, sizeof(buffer), fd)) continue;
		buffer[strlen(buffer)-1]=0;
		
		Value=strstr(buffer, "=");
		if(!Value) continue;
		
		*Value=0;
		Value++;

		if(strcasecmp(buffer, ENV_PKI_SERVER)==0)
		{
			strcpy(LogInfos.Server, Value);
		}
		else if(strcasecmp(buffer, ENV_PKI_PORT)==0)
		{
			sscanf(Value, "%d", &(LogInfos.Port));
		}
		else if(strcasecmp(buffer, ENV_PKI_USER)==0)
		{
			strcpy(LogInfos.Username, Value);
		}
		else if(strcasecmp(buffer, ENV_PKI_CA)==0)
		{
			strcpy(LogInfos.CaName, Value);
		}
		else if(strcasecmp(buffer, ENV_PKI_TYPE)==0)
		{
			Type = *Value;
		}
		else if(strcasecmp(buffer, ENV_PKI_P12FILE)==0)
		{
			strcpy(p12file, Value);
		}
	}
	fclose(fd);

	((wxRadioButton *)FindWindow(IDC_TYPE_MS_CERT))->Enable(FALSE);
	((wxComboBox *)FindWindow(IDC_LIST_CERT))->Enable(FALSE);
	((wxComboBox *)FindWindow(IDC_LIST_CERT))->Append(_("MS Windows only"));
	((wxComboBox *)FindWindow(IDC_LIST_CERT))->SetSelection(0);

	switch(Type)
	{
		case '1':
			((wxRadioButton *)FindWindow(IDC_TYPE_LOGIN))->SetValue(true);
			OnLoginPassord(event);
			break;
		case '3':
			((wxRadioButton *)FindWindow(IDC_TYPE_P12_CERT))->SetValue(true);
			((wxTextCtrl *)FindWindow(IDC_P12_FILE))->SetValue(p12file);
			OnPKCS12(event);
			break;
		default:
			((wxRadioButton *)FindWindow(IDC_TYPE_LOGIN))->SetValue(true);
			OnLoginPassord(event);
			break;
	}
#endif
}

void DlgLogin::WriteConf()
{
	char Type[2];
	wxString currValue;

	if(((wxRadioButton *)FindWindow(IDC_TYPE_LOGIN))->GetValue())
	{
		strcpy(Type, "1");
	}
#ifdef _WIN32
	else if(((wxRadioButton *)FindWindow(IDC_TYPE_MS_CERT))->GetValue())
	{
		strcpy(Type, "2");
	}
#endif
	else if(((wxRadioButton *)FindWindow(IDC_TYPE_P12_CERT))->GetValue())
	{
		strcpy(Type, "3");
	}



#ifdef _WIN32
	char Port[15];
	sprintf(Port, "%d", LogInfos.Port);


	SetLoginValue(ENV_PKI_USER, LogInfos.Username);
	SetLoginValue(ENV_PKI_SERVER, LogInfos.Server);
	SetLoginValue(ENV_PKI_PORT, Port);
	SetLoginValue(ENV_PKI_CA, LogInfos.CaName);
	SetLoginValue(ENV_PKI_TYPE, Type);

	currValue = ((wxTextCtrl *)FindWindow(IDC_P12_FILE))->GetValue();
	SetLoginValue(ENV_PKI_P12FILE, (char*)currValue.GetData());

	currValue = ((wxComboBox *)FindWindow(IDC_LIST_CERT))->GetValue();
	SetLoginValue(ENV_PKI_CERTNAME, (char*)currValue.GetData());
#else
	char buffer[500];
	char * path = getenv("HOME");
	if(!path) return;
	sprintf(buffer, "%s%s", path, ENV_PKI_FILE);

	FILE * fd = fopen(buffer, "w");
	if(!fd) return;

	currValue = ((wxTextCtrl *)FindWindow(IDC_P12_FILE))->GetValue();

	fprintf(fd, "%s=%s\n", ENV_PKI_USER, LogInfos.Username);
	fprintf(fd, "%s=%s\n", ENV_PKI_SERVER, LogInfos.Server);
	fprintf(fd, "%s=%d\n", ENV_PKI_PORT, LogInfos.Port);
	fprintf(fd, "%s=%s\n", ENV_PKI_CA, LogInfos.CaName);
	fprintf(fd, "%s=%s\n", ENV_PKI_TYPE, Type);
	fprintf(fd, "%s=%s\n", ENV_PKI_P12FILE, (char*)currValue.GetData());

	fclose(fd);
#endif
}

void DlgLogin::OnLoginPassord(wxCommandEvent& event)
{
	((wxStaticText *)FindWindow(IDC_LBL_USERNAME))->Enable(TRUE);
	((wxStaticText *)FindWindow(IDC_LBL_PASSWORD))->Enable(TRUE);
	((wxTextCtrl *)FindWindow(IDC_USERNAME))->Enable(TRUE);
	((wxTextCtrl *)FindWindow(IDC_PASSWORD))->Enable(TRUE);

	
	((wxComboBox *)FindWindow(IDC_LIST_CERT))->Enable(FALSE);

	((wxTextCtrl *)FindWindow(IDC_P12_FILE))->Enable(FALSE);
	((wxButton *)FindWindow(IDC_BROWSE_P12))->Enable(FALSE);
}

void DlgLogin::OnMSCERT(wxCommandEvent& event)
{
	((wxStaticText *)FindWindow(IDC_LBL_USERNAME))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_LBL_PASSWORD))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_USERNAME))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_PASSWORD))->Enable(FALSE);

#ifdef _WIN32
	((wxComboBox *)FindWindow(IDC_LIST_CERT))->Enable(TRUE);
#endif

	((wxTextCtrl *)FindWindow(IDC_P12_FILE))->Enable(FALSE);
	((wxButton *)FindWindow(IDC_BROWSE_P12))->Enable(FALSE);
}

void DlgLogin::OnPKCS12(wxCommandEvent& event)
{
	((wxStaticText *)FindWindow(IDC_LBL_USERNAME))->Enable(FALSE);
	((wxStaticText *)FindWindow(IDC_LBL_PASSWORD))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_USERNAME))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_PASSWORD))->Enable(FALSE);

	
	((wxComboBox *)FindWindow(IDC_LIST_CERT))->Enable(FALSE);

	((wxTextCtrl *)FindWindow(IDC_P12_FILE))->Enable(TRUE);
	((wxButton *)FindWindow(IDC_BROWSE_P12))->Enable(TRUE);
}

void DlgLogin::OnBrowsePKC12(wxCommandEvent& event)
{
	wxFileDialog dialog(this, "Open PKCS#12", "", "", "PKCS#12 File (*.p12)|*.p12", wxOPEN);
	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}
	((wxTextCtrl *)FindWindow(IDC_P12_FILE))->SetValue(dialog.GetPath());
}
