/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgGetNewPassword.cpp: implementation of the DlgGetNewPassword class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgGetNewPassword.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////
BEGIN_EVENT_TABLE(DlgGetNewPassword, wxDialog)
    EVT_BUTTON(IDC_OK, DlgGetNewPassword::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgGetNewPassword::OnCancel)
END_EVENT_TABLE()

DlgGetNewPassword::DlgGetNewPassword(wxWindow * wParent):wxDialog(wParent, (wxWindowID)-1, _("New password"), wxDefaultPosition, wxDefaultSize, wxSYSTEM_MENU | wxMINIMIZE_BOX | wxCAPTION)
{
	m_IsOK=false;
	DlgGetNewPassword_SetWindow(this);
	CenterOnScreen();
	ShowModal();
}

DlgGetNewPassword::~DlgGetNewPassword()
{
}

const mString & DlgGetNewPassword::GetPassword()
{
	return m_Password;
}

bool DlgGetNewPassword::IsOK()
{
	return m_IsOK;
}

void DlgGetNewPassword::OnOk(wxCommandEvent& event)
{
	wxString Pwd1;
	wxString Pwd2;

	Pwd1 = ((wxTextCtrl *)FindWindow(IDC_PWD1))->GetValue();
	Pwd2 = ((wxTextCtrl *)FindWindow(IDC_PWD2))->GetValue();
	if(!Pwd1.Len() || !Pwd2.Len()) return;

	if(wxStrcmp(Pwd1, Pwd2) != 0)
	{
		HandleError(_("The two passwords don't match."), this);
		return;
	}

	m_Password = Pwd1.GetData();

	m_IsOK = true;

	Close(TRUE);
}

void DlgGetNewPassword::OnCancel(wxCommandEvent& event)
{
	m_IsOK = false;
	Close(TRUE);
}
