/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgConfigurePlugin.h: interface for the DlgConfigurePlugin class.
//
//////////////////////////////////////////////////////////////////////

#ifndef DLGCONFIGUREPLUGIN_H
#define DLGCONFIGUREPLUGIN_H

#ifdef __GNUG__
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx/wx.h".
#include <wx/wxprec.h>

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include <wx/imaglist.h>
#include <wx/listctrl.h>
#include <wx/dialog.h>



#include "DlgAddValuePlugin.h"

#include <stdio.h>
#include <string.h>
#include <HashTable/HashTable_String.h>
#include "Error.h"
#include "Functions.h"
#include <libxml/parserInternals.h>
#include <libxml/parser.h>

class DlgConfigurePlugin: public wxDialog
{
public:
	DlgConfigurePlugin(wxWindow * wParent, HashTable_String * Options, const mString & LibPath);
	virtual ~DlgConfigurePlugin();
	
	bool IsOK();
	const mString & GetLibPath();

	void OnBrowseXML(wxCommandEvent& event);
	void OnDelValue(wxCommandEvent& event);
	void OnModifyValue(wxCommandEvent& event);
	void OnAddValue(wxCommandEvent& event);
	void OnOk(wxCommandEvent& event);
	void OnCancel(wxCommandEvent& event);


private:
	wxListCtrl * m_listCtrl;
	wxImageList *m_imageListSmall;

	void ReloadList();
	bool m_IsOk;
	HashTable_String * m_Options;
	HashTable_String SavedListe;
	xmlParserCtxtPtr ctxt;
	mString m_LibPath;

	DECLARE_EVENT_TABLE()
};

#endif
