/*
	Copyright (C) 2003 Frdric Giudicelli (contact_nos@yahoo.com). 
	All rights reserved.

	This product includes cryptographic software written by Eric Young
	(eay@cryptsoft.com)

	This program is released under the GPL with the additional exemption that
	compiling, linking, and/or using OpenSSL is allowed.

	This program is free software; you can redistribute it and/or modify it
	under the terms of the GNU General Public License as published by the Free
	Software Foundation; either version 2 of the License.

	This program is distributed in the hope that it will be useful, but WITHOUT
	ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
	FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
	more details.

	You should have received a copy of the GNU General Public License along with
	this program; if not, write to the Free Software Foundation, Inc., 59 Temple
	Place, Suite 330, Boston, MA 02111-1307 USA
*/


// DlgAddPubMeth.cpp: implementation of the DlgAddPubMeth class.
//
//////////////////////////////////////////////////////////////////////

#include "DlgAddPubMeth.h"
#include "dlgs_wdr.h"
#include "clintl.h"


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

BEGIN_EVENT_TABLE(DlgAddPubMethListCtrl, wxListCtrl)
    EVT_LIST_ITEM_SELECTED(IDC_LIST_FIELDS, DlgAddPubMethListCtrl::OnItemClick)
END_EVENT_TABLE()


void DlgAddPubMethListCtrl::OnItemClick(wxListEvent& event)
{
	DlgAddPubMeth * wParent = (DlgAddPubMeth *)GetParent();
	wParent->OnItemClick(event);
}


BEGIN_EVENT_TABLE(DlgAddPubMeth, wxDialog)
    EVT_BUTTON(IDC_OK, DlgAddPubMeth::OnOk)
    EVT_BUTTON(IDC_CANCEL, DlgAddPubMeth::OnCancel)
    EVT_BUTTON(IDC_BROWSE_XML, DlgAddPubMeth::OnBrowseXML)
	EVT_TEXT(IDC_VALUE, DlgAddPubMeth::OnValueChanged)
END_EVENT_TABLE()

DlgAddPubMeth::DlgAddPubMeth(wxWindow * wParent, const PublicationMethodInfo & pubEntry):wxDialog(wParent, (wxWindowID)-1, (pubEntry?_("Modify Publication Method"):_("Add Publication Method")), wxDefaultPosition)
{
	ctxt = NULL;
	m_Entry = pubEntry;

	m_IsOk = false;

	DlgAddPubMeth_SetWindow(this);

	m_listCtrl = ((wxListCtrl *)FindWindow(IDC_LIST_FIELDS));

	wxIcon ico;
	m_imageListSmall = new wxImageList(16, 16, TRUE);
	ico.CopyFromBitmap(DlgConfigurePlugin_GetBitmap(0));
	m_imageListSmall->Add(ico);

	m_listCtrl->SetImageList(m_imageListSmall, wxIMAGE_LIST_SMALL);

	m_listCtrl->InsertColumn(0, _("Name"), wxLIST_FORMAT_LEFT, 130);
	m_listCtrl->InsertColumn(1, _("Value"), wxLIST_FORMAT_LEFT, 80);
	m_listCtrl->InsertColumn(2, _("Type"), wxLIST_FORMAT_LEFT, 50);
	m_listCtrl->InsertColumn(3, _("Help"), wxLIST_FORMAT_LEFT, 130);

	m_listCtrl->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_VALUE))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_NAME))->Enable(FALSE);
	((wxTextCtrl *)FindWindow(IDC_PATH))->Enable(FALSE);
	((wxRadioBox *)FindWindow(IDC_TYPE))->Enable(FALSE);
	((wxButton *)FindWindow(IDC_OK))->Enable(FALSE);

	if(pubEntry)
	{
		((wxTextCtrl *)FindWindow(IDC_NAME))->SetValue(pubEntry.get_name().c_str());
		((wxTextCtrl*)FindWindow(IDC_PATH))->SetValue(pubEntry.get_librarypath().c_str());
		switch(pubEntry.get_type())
		{
			case PUBLICATION_METHOD_INFO_TYPE_CERT:
				((wxRadioBox *)FindWindow(IDC_TYPE))->SetSelection(0);
				break;
			case PUBLICATION_METHOD_INFO_TYPE_CRL:
				((wxRadioBox *)FindWindow(IDC_TYPE))->SetSelection(1);
				break;
			default:
				((wxRadioBox *)FindWindow(IDC_TYPE))->SetSelection(0);
				break;
		}
	}
	ReloadList();

	CenterOnScreen();
	ShowModal();
}

DlgAddPubMeth::~DlgAddPubMeth()
{
	if(m_imageListSmall) delete m_imageListSmall;
	if(ctxt) xmlFreeParserCtxt(ctxt);
}


void DlgAddPubMeth::ReloadList()
{
	const char * Value;
	xmlNodePtr root;
	xmlNodePtr currOption;
	xmlAttrPtr currAttr;
	xmlChar * OptionName;
	xmlChar * AttrValue;
	mString Helper;
	mString Type;
	size_t i;

	if(!ctxt)
		return;

	root = xmlDocGetRootElement(ctxt->myDoc);

	m_listCtrl->DeleteAllItems();

	if(root)
	{
		for(currOption = root->children; currOption; currOption=currOption->next)
		{
			if(xmlIsBlankNode(currOption)) continue;
			OptionName = xmlNodeGetContent(currOption);
			if(!OptionName || !*OptionName) continue;

			for(currAttr = currOption->properties; currAttr; currAttr = currAttr->next)
			{				
				//Convert datas to SQL format
				AttrValue = xmlGetProp(currOption, currAttr->name);
				if(xmlStrcasecmp(currAttr->name, (unsigned char*)"help") == 0)
					Helper = AttrValue;
				else if(xmlStrcasecmp(currAttr->name, (unsigned char*)"type") == 0)
					Type = AttrValue;
				xmlFree(AttrValue);
			}

			Value = "";

			// Let's get the value
			for(i=0; i<m_Entry.get_options().size(); i++)
			{
				if(!(m_Entry.get_options()[i].get_name() == OptionName))
					continue;

				Value = m_Entry.get_options()[i].get_value().c_str();
			}

			i = m_listCtrl->GetItemCount();

			m_listCtrl->InsertItem(i, OptionName, 0);
			m_listCtrl->SetItem(i, 1, Value);
			m_listCtrl->SetItem(i, 2, Type.c_str());
			m_listCtrl->SetItem(i, 3, Helper.c_str());

			xmlFree(OptionName);
		}
	}
}


void DlgAddPubMeth::OnValueChanged(wxCommandEvent& event)
{
	wxString Value;

	long SelectedItem;

	if(!ctxt) return;


	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;

	Value = ((wxTextCtrl *)FindWindow(IDC_VALUE))->GetValue();
	m_listCtrl->SetItem(SelectedItem, 1, Value.GetData());
}


bool DlgAddPubMeth::IsOK()
{
	return m_IsOk;
}


void DlgAddPubMeth::OnOk(wxCommandEvent& event)
{
	int nItem;
	int ItemCount;
	wxString Name;
	wxString Value;
	wxListItem item;
	PlugOption option;

	m_Entry.get_options().clear();


	ItemCount = m_listCtrl->GetItemCount();

	for(nItem=0; nItem<ItemCount; nItem++)
	{
		Name = m_listCtrl->GetItemText(nItem);
		if(!Name.Len())
			return;

		item.SetMask(wxLIST_MASK_TEXT);
		item.SetId(nItem);
		item.SetColumn(1);
		if (!m_listCtrl->GetItem(item))
		{
			return;
		}
		Value = item.GetText();

		option.set_name(Name.GetData());
		option.set_value(Value.GetData());

		m_Entry.get_options().push_back(option);
	}


	
	Name = ((wxTextCtrl*)FindWindow(IDC_PATH))->GetValue();
	if(!Name.Len())
		return;
	m_Entry.set_librarypath(Name.GetData());

	Name = ((wxTextCtrl*)FindWindow(IDC_NAME))->GetValue();
	if(!Name.Len())
		return;
	m_Entry.set_name(Name.GetData());

	switch(((wxRadioBox *)FindWindow(IDC_TYPE))->GetSelection())
	{
		case 0:
			m_Entry.set_type(PUBLICATION_METHOD_INFO_TYPE_CERT);
			break;
		case 1:
			m_Entry.set_type(PUBLICATION_METHOD_INFO_TYPE_CRL);
			break;
		default:
			m_Entry.set_type(PUBLICATION_METHOD_INFO_TYPE_CERT);
			break;
	}

	m_IsOk = true;
	Close(TRUE);
}


void DlgAddPubMeth::OnBrowseXML(wxCommandEvent& event)
{
	wxFileDialog dialog(this, _("Open XML options template"), "", "", "XML (*.xml)|*.xml", wxOPEN);
	if (dialog.ShowModal() != wxID_OK)
	{
		return;
	}
	if(ctxt)
	{
		xmlFreeParserCtxt(ctxt);
		ctxt = NULL;
	}

	ctxt = xmlCreateFileParserCtxt(dialog.GetPath());
    xmlParseDocument(ctxt);
    if (!ctxt->wellFormed || !ctxt->valid)
	{
		HandleError(_("Invalid XML template"), this);
		return;
	}
	((wxTextCtrl*)FindWindow(IDC_XML_OPTION))->SetValue(dialog.GetPath());

	m_listCtrl->Enable(TRUE);
	((wxTextCtrl *)FindWindow(IDC_VALUE))->Enable(TRUE);
	((wxTextCtrl *)FindWindow(IDC_NAME))->Enable(TRUE);
	((wxTextCtrl *)FindWindow(IDC_PATH))->Enable(TRUE);
	((wxRadioBox *)FindWindow(IDC_TYPE))->Enable(TRUE);
	((wxButton *)FindWindow(IDC_OK))->Enable(TRUE);

	ReloadList();
}

void DlgAddPubMeth::OnCancel(wxCommandEvent& event)
{
	m_IsOk = false;
	Close(TRUE);
}

const PublicationMethodInfo & DlgAddPubMeth::GetPublication()
{
	if(!m_IsOk)
		return PublicationMethodInfo::EmptyInstance;

	return m_Entry;
}

void DlgAddPubMeth::OnItemClick(wxListEvent &event)
{
	long SelectedItem;
	wxListItem item;


	SelectedItem = m_listCtrl->GetNextItem(-1, wxLIST_NEXT_ALL, wxLIST_STATE_SELECTED);
	if(SelectedItem == -1) return;



	item.SetMask(wxLIST_MASK_TEXT);
	item.SetId(SelectedItem);
	item.SetColumn(1);
	if (!m_listCtrl->GetItem(item))
	{
		return;
	}

	((wxTextCtrl *)FindWindow(IDC_VALUE))->SetValue(item.GetText().GetData());
}
