// Copyright (c) 2004 Divmod.
// See LICENSE for details.


// variables injected into the global namespace are:
//  cookie
//  port
//  prefix

// GLOBALS

var server = new XMLSocket();

var canvas = _root.createEmptyMovieClip('canvas', 0);


// DRAWING APIS

function extractList(nodes) {
    var rv = [];
    for (i=0; i<nodes.length; i++) {
        rv.push(
            Number(nodes[i].attributes['v'])); }
    return rv; }

function extractDict(nodes) {
    var rv = {};
    for (i=0; i<nodes.length; i++) {
        var nod = nodes[i];
        var val = nod.attributes['v'];
        if (val == "matrixType") {
            rv[nod.attributes['k']] = val; }
        else {
            rv[nod.attributes['k']] = Number(val); } }
    return rv; }

function gradient(type, colors, alphas, ratios, matrix) {
    var cl = extractList(colors);
    var al = extractList(alphas);
    var ra = extractList(ratios);
    var ma = extractDict(matrix);
    canvas.beginGradientFill(
        type, cl, al, ra, ma) }

function curve(controlX, controlY, anchorX, anchorY) {
    canvas.curveTo(
        Number(controlX),
        Number(controlY),
        Number(anchorX),
        Number(anchorY)); }

function fill(rgb, alpha) {
    canvas.beginFill(Number(rgb), Number(alpha)); }

function close() {
    canvas.endFill(); }

function move(x, y) {
    canvas.moveTo(Number(x), Number(y)); }

function line(x, y) {
	canvas.lineTo(Number(x), Number(y));	}

function pen(w, c, a) {
    if (a) {
        canvas.lineStyle(Number(w), Number(c), Number(a)) }
    else if (c) {
        canvas.lineStyle(Number(w), Number(c)); } 
    else if (w) {
        canvas.lineStyle(Number(w)); }
    else {
        canvas.lineStyle(); } }


function clear() {
    canvas.clear(); }



// TEXT APIS

function text(cookie, val, x, y, height, width) {
    canvas.createTextField(
        "T_" + cookie, Number(cookie), 
        Number(x), Number(y), Number(height), Number(width));
    var T = canvas["T_" + cookie]
    T.text = val;
    T.selectable = false;
//    T.background = true;
//    T.backgroundColor = 0xefefef;
    }

function changeText(cookie, val) {
    canvas["T_" + cookie].text = val; }

function moveText(cookie, x, y) {
    var T = canvas["T_" + cookie];
    T._x = Number(x);
    T._y = Number(y); }

function rotateText(cookie, angle) {
    var A = Number(angle);
    canvas["T_" + cookie]._rotation = A; }

function listFonts(identifier) {
    var fonts = TextField.getFontList();
    server.send(
        identifier + " " + fonts); }

function font(cookie, fn) {
    var T = canvas["T_" + cookie];
    var F = T.getTextFormat();
    F.font = fn;
    T.setTextFormat(F); }

function size(cookie, s) {
    var T = canvas["T_" + cookie];
    var F = T.getTextFormat();
    F.size = Number(s);
    T.setTextFormat(F); }

// IMAGE APIs

function image(cookie, where) {
    canvas.createEmptyMovieClip("I_"+cookie, Number(cookie));
    var I = canvas["I_"+cookie];
    I.loadMovie(where); }

function moveImage(cookie, x, y) {
    var I = canvas["I_" + cookie];
    I._x = Number(x);
    I._y = Number(y); }

function scaleImage(cookie, x, y) {
    var I = canvas["I_" + cookie];
    I._xscale = Number(x);
    I._yscale = Number(y); }

function alphaImage(cookie, alpha) {
    var I = canvas["I_" + cookie];
    I._alpha = Number(alpha); }

function rotateImage(cookie, angle) {
    var T = canvas["I_" + cookie];
    T._rotation = Number(angle); }

// SERVER GLUE

server.onXML = function(xml) {
	xml = xml.firstChild;
	var funcName = xml.attributes['n'];
	var func = eval(funcName);
	var parms = [];
	for(i=0; i<xml.childNodes.length; i++) {
        if (xml.childNodes[i].attributes['v']){
            parms.push(
                xml.childNodes[i].attributes['v']); }
        else {
            parms.push(
                xml.childNodes[i].childNodes[0].childNodes); } }
	func.apply(_root, parms); }

server.onConnect = function(success) {
	if (success) {
		server.send(
			"GET " + prefix + "canvas_socket/"+
			cookie+
			" HTTP/1.0\r\n\r\n"); } }

server.connect(null, port);
