#include <stdio.h>
#include <unistd.h>

#include "libnomad/libnomad.h"

njb_t njbs[ NJB_MAX_DEVICES ];

static void usage( NomadJukebox *jukebox, guint jobid,
		guint64 total, guint64 free, guint64 used,
		gpointer data )
{
	gint *done;
	const gchar *owner;
	
	done = (gint*)data;

	owner = nomad_jukebox_get_ownerstring( jukebox );
	
	printf( "%s is using: %i meg of %i meg\tFree: %i meg\n",
			owner,
			(int)(( used / 1024.0 ) / 1024.0 ), 
			(int)(( total / 1024.0 ) / 1024.0 ), 
			(int)(( free / 1024.0 ) / 1024.0 ) );
	(*done) --;
}

int main()
{
	guint number;
	gint done;
	NomadJukebox *jukebox;
	GSList *list;
	gint i;
	
	g_type_init();
	g_thread_init( NULL );
	
	NJB_Set_Unicode( NJB_UC_UTF8 );

	number = 0;
	if( NJB_Discover( njbs, 0, &number ) == -1 ) {
		fprintf( stderr, "Error discovering jukeboxes\n" );
	}
	if( number == 0 ) {
		fprintf( stderr, "no NJB devices found\n" );
		return 0;
	}
	done = number;
	list = NULL;
	
	for( i = 0; i < number; i ++ ) {
		jukebox = nomad_jukebox_new( &njbs[ i ] );
		if( ! nomad_jukebox_acquire( jukebox ) ) {
			fprintf( stderr, "failed to acquire jukebox %i\n", i );
			done --;
		} else {
			list = g_slist_prepend( list, jukebox );
			g_signal_connect( G_OBJECT( jukebox ), 
					"usage",
					G_CALLBACK( usage ), 
					&done );
			nomad_jukebox_getusage( jukebox );
		}
	}
	
	while( done > 0 ) {
		usleep( 100 );
	}
	g_slist_foreach( list, nomad_jukebox_release, NULL );
	g_slist_free( list );

	return 0;
}

