#ifndef NOMAD_JUKEBOX_TRACK_H
#define NOMAD_JUKEBOX_TRACK_H

typedef struct NomadTrack NomadTrack;

NomadTrack* nomad_track_new( const gchar *artist, const gchar *title,
				   const gchar *album, const gchar *genre,
				   const gchar *length, const gchar *year,
				   const gchar *size, const gchar *codec,
				   const gchar *track, const gchar *name );
NomadTrack* nomad_track_new_with_id( guint id,
					   const gchar *artist,
					   const gchar *title,
					   const gchar *album,
					   const gchar *genre,
					   const gchar *length,
					   const gchar *year,
					   const gchar *size,
					   const gchar *codec,
					   const gchar *track, 
					   const gchar *name );
NomadTrack* nomad_track_copy( const NomadTrack *track );
NomadTrack* nomad_track_copy_and_protect( const NomadTrack *track, 
		gboolean protect );
void nomad_track_free( NomadTrack *track );

guint nomad_track_get_id( const NomadTrack *track );
gchar *nomad_track_get_artist( const NomadTrack *track );
gchar *nomad_track_get_title( const NomadTrack *track );
gchar *nomad_track_get_album( const NomadTrack *track );
gchar *nomad_track_get_genre( const NomadTrack *track );
gchar *nomad_track_get_length( const NomadTrack *track );
gchar *nomad_track_get_year( const NomadTrack *track );
gchar *nomad_track_get_size( const NomadTrack *track );
gchar *nomad_track_get_codec( const NomadTrack *track );
gchar *nomad_track_get_track( const NomadTrack *track );
gchar *nomad_track_get_name( const NomadTrack *track );
gboolean nomad_track_get_play_only( const NomadTrack *track );

void nomad_track_get( const NomadTrack *track,
			 gchar **artist, gchar **title,
			 gchar **album, gchar **genre, gchar **length,
			 gchar **year, gchar **size, gchar **codec,
			 gchar **trck, gchar **name, guint *id );

#endif
