 /*
 *  Copyright (C) 2003  David A Knight
 *  
 *  based on ephy-automation.c,
 *  Copyright (C) 2000, 2001, 2002 Marco Pesenti Gritti
 *  
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */


#include "neutrino-application.h"
#include "neutrino.h"
#include "neutrino-shell.h"
#include "nomad-jukebox.h"
#include "neutrino-window.h"

#include <bonobo/bonobo-generic-factory.h>
#include <bonobo/bonobo-main.h>
#include <bonobo/bonobo-context.h>


static void impl_neutrino_application_quit( PortableServer_Servant _servant,
		CORBA_Environment *ev );
static void impl_neutrino_application_create_window( PortableServer_Servant _servant,
		CORBA_Environment *ev );
static CORBA_long impl_neutrino_application_get_jukeboxes( PortableServer_Servant _servant,
		CORBA_Environment *ev );
static Neutrino_Jukebox impl_neutrino_application_get_jukebox( PortableServer_Servant __servant,
		CORBA_long index,
		CORBA_Environment *ev );
static Neutrino_Jukebox impl_neutrino_application_get_jukebox_by_id( PortableServer_Servant __servant,
		CORBA_string id,
		CORBA_Environment *ev );


static gboolean set_jukebox_cb( gpointer data );

static void neutrino_application_class_init( NeutrinoApplicationClass *klass );
static void neutrino_application_init( NeutrinoApplication *app );
static void neutrino_application_finalize( GObject *obj );

static BonoboObject *neutrino_application_factory( BonoboGenericFactory *factory,
		const char *iid,
		gpointer data );

static GObjectClass *neutrino_application_parent_class;

#define NEUTRINO_FACTORY_OAFIID "OAFIID:Neutrino_Factory"

static BonoboObject *neutrino_application_factory( BonoboGenericFactory *factory,
		const char *iid,
		gpointer data )
{
	NeutrinoApplication *a;

	a = g_object_new( NEUTRINO_APPLICATION_TYPE, NULL );

	return BONOBO_OBJECT( a );
}

BonoboObject *neutrino_application_new( void )
{
	BonoboGenericFactory *factory;

	factory = bonobo_generic_factory_new( NEUTRINO_FACTORY_OAFIID,
			neutrino_application_factory,
			NULL );

	g_return_val_if_fail( factory != NULL, NULL );

	return BONOBO_OBJECT( factory );
}

static void impl_neutrino_application_quit( PortableServer_Servant _servant,
		CORBA_Environment *ev )
{
	neutrino_shell_close_all_windows( neutrino_shell );
}

static void impl_neutrino_application_create_window( PortableServer_Servant _servant,
		CORBA_Environment *ev )
{
	NeutrinoWindow *window;

	window = neutrino_shell_create_window( neutrino_shell );
	
	gdk_threads_enter();
	gtk_widget_show( GTK_WIDGET( window ) );

	/* need to give time for the window to display,
	 * or pango gets a little upset sometimes */
	g_idle_add( (GSourceFunc)set_jukebox_cb, window );

	gdk_threads_leave();
}

static CORBA_long impl_neutrino_application_get_jukeboxes( PortableServer_Servant _servant,
		CORBA_Environment *ev )
{
	guint boxes;

	boxes = neutrino_shell_get_jukeboxes( neutrino_shell );

	return boxes;
}

static Neutrino_Jukebox impl_neutrino_application_get_jukebox( PortableServer_Servant __servant,
		CORBA_long index,
		CORBA_Environment *ev )
{
	BonoboObject *obj;
	NomadJukebox *box;

	box = neutrino_shell_get_nth_jukebox( neutrino_shell, index );
	obj = CORBA_OBJECT_NIL;
	if( box ) {
		obj = BONOBO_OBJECT( box );
	}

	return bonobo_object_corba_objref( obj );
}

static Neutrino_Jukebox impl_neutrino_application_get_jukebox_by_id( PortableServer_Servant __servant,
		CORBA_string id,
		CORBA_Environment *ev )
{
	BonoboObject *obj;
	NomadJukebox *box;

	box = neutrino_shell_get_jukebox_by_id( neutrino_shell, id );
	obj = CORBA_OBJECT_NIL;
	if( box ) {
		obj = BONOBO_OBJECT( box );
	}

	return bonobo_object_corba_objref( obj );
}



static gboolean set_jukebox_cb( gpointer data )
{
	NomadJukebox *box;
	NeutrinoWindow *window;

	box = NULL;
	if( neutrino_shell_get_jukeboxes( neutrino_shell ) > 0 ) {
		box = neutrino_shell_get_nth_jukebox( neutrino_shell, 
						0 );
	}
	window = NEUTRINO_WINDOW( data );
	neutrino_window_set_jukebox( window, box );

	return FALSE;
}

static void neutrino_application_class_init( NeutrinoApplicationClass *klass )
{
	GObjectClass *obj_class;
	POA_Neutrino_Application__epv *epv;
	
	obj_class = G_OBJECT_CLASS( klass );
	epv = &klass->epv;

	neutrino_application_parent_class = g_type_class_peek_parent( klass );
	obj_class->finalize = neutrino_application_finalize;

	epv->quit = impl_neutrino_application_quit;
	epv->create_window = impl_neutrino_application_create_window;
	epv->get_jukeboxes = impl_neutrino_application_get_jukeboxes;
	epv->get_jukebox = impl_neutrino_application_get_jukebox;
	epv->get_jukebox_by_id = impl_neutrino_application_get_jukebox_by_id;
}

static void neutrino_application_init( NeutrinoApplication *app )
{

}

static void neutrino_application_finalize( GObject *obj )
{
	NeutrinoApplication *app;

	app = NEUTRINO_APPLICATION( obj );

	neutrino_application_parent_class->finalize( G_OBJECT( app ) );
}

BONOBO_TYPE_FUNC_FULL( NeutrinoApplication,
			Neutrino_Application,
			BONOBO_TYPE_OBJECT,
			neutrino_application );
