
/*-------------------------------------------------------------*/
/* MD4: rfc 1320
   MD5: rfc 1321
*/
typedef enum {
  NETWOX_MDVERSION_4 = 4,
  NETWOX_MDVERSION_5 = 5,
} netwox_mdversion;

/*-------------------------------------------------------------*/
typedef struct {
  /* version */
  netwox_mdversion mdversion;
  /* future result */
  netwib_uint32 a;
  netwib_uint32 b;
  netwib_uint32 c;
  netwib_uint32 d;
  /* number of bits */
  netwib_uint64 totalbits;
  /* temporary storage */
  netwib_byte buf[64];
  netwib_uint32 bufsize;
} netwox_md_context;

/*-------------------------------------------------------------*/
#define NETWOX_MD_HASH_LEN 16
#define NETWOX_MD4_HASH_LEN NETWOX_MD_HASH_LEN
#define NETWOX_MD5_HASH_LEN NETWOX_MD_HASH_LEN

/*-------------------------------------------------------------*/
netwib_err netwox_md_init(netwox_mdversion mdversion,
                          netwox_md_context *pcontext);
#define netwox_md4_init(pcontext) netwox_md_init(NETWOX_MDVERSION_4,pcontext)
#define netwox_md5_init(pcontext) netwox_md_init(NETWOX_MDVERSION_5,pcontext)
netwib_err netwox_md_update(netwox_md_context *pcontext,
                            netwib_constbuf *pbuf);
netwib_err netwox_md_final(netwox_md_context *pcontext,
                           netwib_buf *pmd);

/*-------------------------------------------------------------*/
netwib_err netwox_md_final_hexa(netwox_md_context *pcontext,
                                netwib_buf *phexamd);

/*-------------------------------------------------------------*/
netwib_err netwox_md_compute(netwox_mdversion mdversion,
                             netwib_constbuf *pbuf,
                             netwib_buf *pmd);
#define netwox_md4_compute(pbuf,pmd) netwox_md_compute(NETWOX_MDVERSION_4,pbuf,pmd)
#define netwox_md5_compute(pbuf,pmd) netwox_md_compute(NETWOX_MDVERSION_5,pbuf,pmd)
netwib_err netwox_md_compute_hexa(netwox_mdversion mdversion,
                                  netwib_constbuf *pbuf,
                                  netwib_buf *phexamd);
#define netwox_md4_compute_hexa(pbuf,pmd) netwox_md_compute_hexa(NETWOX_MDVERSION_4,pbuf,pmd)
#define netwox_md5_compute_hexa(pbuf,pmd) netwox_md_compute_hexa(NETWOX_MDVERSION_5,pbuf,pmd)

/*-------------------------------------------------------------*/
netwib_err netwox_md_compute_file(netwox_mdversion mdversion,
                                  netwib_constbuf *pfilename,
                                  netwib_buf *phexamd);
#define netwox_md4_compute_file(pfilename,phexamd) netwox_md_compute_file(NETWOX_MDVERSION_4,pfilename,phexamd)
#define netwox_md5_compute_file(pfilename,phexamd) netwox_md_compute_file(NETWOX_MDVERSION_5,pfilename,phexamd)

/*-------------------------------------------------------------*/
netwib_err netwox_md_test(netwox_mdversion mdversion);
