
/*-------------------------------------------------------------*/
/***************************************************************
 * Type netwib_uint64, can be represented as:                  *
 *  - a 64 bit integer                                         *
 *  - a structure containing two 32 bit integers               *
 * In the first case, math operations are supported by the     *
 * compiler.                                                   *
 * In the second case, following functions are needed.         *
 ***************************************************************/

/*-------------------------------------------------------------*/
netwib_err netwib_uint64_init_uint32(netwib_uint32 in,
                                     netwib_uint64 *pout);
netwib_err netwib_uint64_init_uintmax(netwib_uintmax in,
                                      netwib_uint64 *pout);
netwib_err netwib_uint64_init_uintptr(netwib_uintptr in,
                                      netwib_uint64 *pout);
netwib_err netwib_int64_init_int32(netwib_int32 in,
                                   netwib_int64 *pout);
netwib_err netwib_int64_init_intmax(netwib_intmax in,
                                    netwib_int64 *pout);
netwib_err netwib_int64_init_intptr(netwib_intptr in,
                                    netwib_int64 *pout);
netwib_err netwib_uint32_init_uint64(netwib_uint64 in,
                                     netwib_uint32 *pout);
netwib_err netwib_uintmax_init_uint64(netwib_uint64 in,
                                      netwib_uintmax *pout);
netwib_err netwib_uintptr_init_uint64(netwib_uint64 in,
                                      netwib_uintptr *pout);
netwib_err netwib_int32_init_int64(netwib_int64 in,
                                   netwib_int32 *pout);
netwib_err netwib_intmax_init_int64(netwib_int64 in,
                                    netwib_intmax *pout);
netwib_err netwib_intptr_init_int64(netwib_int64 in,
                                    netwib_intptr *pout);

/*-------------------------------------------------------------*/
netwib_err netwib_uint64_init_int64(netwib_int64 in,
                                    netwib_uint64 *pout);
netwib_err netwib_int64_init_uint64(netwib_uint64 in,
                                    netwib_int64 *pout);

/*-------------------------------------------------------------*/
netwib_err netwib_uint64_add(netwib_uint64 a,
                             netwib_uint64 b,
                             netwib_uint64 *paplusb);
#define netwib_int64_add(a,b,paplusb) netwib_uint64_add(a,b,paplusb)
netwib_err netwib_uint64_sub(netwib_uint64 a,
                             netwib_uint64 b,
                             netwib_uint64 *paminusb);
#define netwib_int64_sub(a,b,paminusb) netwib_uint64_sub(a,b,paminusb)
netwib_err netwib_uint64_mul(netwib_uint64 a,
                             netwib_uint64 b,
                             netwib_uint64 *pamulb);
#define netwib_int64_mul(a,b,pamulb) netwib_uint64_mul(a,b,pamulb)
netwib_err netwib_uint64_div(netwib_uint64 n,
                             netwib_uint64 d,
                             netwib_uint64 *pq,
                             netwib_uint64 *pr);
netwib_err netwib_int64_div(netwib_int64 n,
                            netwib_int64 d,
                            netwib_int64 *pq,
                            netwib_int64 *pr);

/*-------------------------------------------------------------*/
netwib_err netwib_uint64_inc(netwib_uint64 *pui);
#define netwib_int64_inc(pui) netwib_uint64_inc(pui)
netwib_err netwib_uint64_dec(netwib_uint64 *pui);
#define netwib_int64_dec(pui) netwib_uint64_dec(pui)

/*-------------------------------------------------------------*/
netwib_err netwib_uint64_cmp(netwib_uint64 a,
                             netwib_uint64 b,
                             netwib_cmp *pcmp);
netwib_err netwib_int64_cmp(netwib_int64 a,
                            netwib_int64 b,
                            netwib_cmp *pcmp);

/*-------------------------------------------------------------*/
netwib_err netwib_int64_neg(netwib_int64 a,
                            netwib_int64 *pnega);

/*-------------------------------------------------------------*/
netwib_err netwib_uint64_shl(netwib_uint64 a,
                             netwib_uint32 b,
                             netwib_uint64 *pashlb);
netwib_err netwib_uint64_shr(netwib_uint64 a,
                             netwib_uint32 b,
                             netwib_uint64 *pashrb);
netwib_err netwib_uint64_and(netwib_uint64 a,
                             netwib_uint64 b,
                             netwib_uint64 *paandb);
netwib_err netwib_uint64_or(netwib_uint64 a,
                            netwib_uint64 b,
                            netwib_uint64 *paorb);
netwib_err netwib_uint64_xor(netwib_uint64 a,
                             netwib_uint64 b,
                             netwib_uint64 *paxorb);
netwib_err netwib_uint64_not(netwib_uint64 a,
                             netwib_uint64 *pnot);

/*-------------------------------------------------------------*/
/* To represent values > 0xFFFFFFFF :
    - some Unixes (Solaris, HP-UX) need 0xf....fLL
    - Windows does not support LL
 */
#if defined NETWIBDEF_SYSNAME_Unix
  #define NETWIB_INT_LL(x) (x ## LL)
  #define NETWIB_UINT_LL(x) (x ## LLU)
#elif defined NETWIBDEF_SYSNAME_Windows
  #define NETWIB_INT_LL(x) (x)
  #define NETWIB_UINT_LL(x) (x)
#else
  #error "Unknown value for NETWIBDEF_SYSNAME"
#endif

