#!/usr/bin/perl
#
# See LICENSE for copyright information
#
# check_users.pl <host> [warn] [critical] [port]
#
# NetSaint host script to get the number of users from a client that is running
# netsaint_statd.
#

require 5.003;
BEGIN { $ENV{PATH} = '/bin' }
use Socket;
use POSIX;
use strict;

sub usage;

my $TIMEOUT = 15;

my %ERRORS = ('UNKNOWN', '-1',
		'OK', '0',
		'WARNING', '1',
		'CRITICAL', '2');
my $remote = shift || &usage(%ERRORS);
my $warn = shift || 15;
my $crit = shift || ($warn + 20);
my $port = shift || 1040;

my $remoteaddr = inet_aton("$remote");
my $paddr = sockaddr_in($port, $remoteaddr) || die "Can't create info for connection: #!\n";;
my $proto = getprotobyname('tcp');
socket(Server, PF_INET, SOCK_STREAM, $proto) || die "Can't create socket: $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR, 1);
connect(Server, $paddr) || die "Can't connect to server: $!";

my $state = "OK";
my $answer = undef;

# Just in case of problems, let's not hang NetSaint
$SIG{'ALRM'} = sub { 
     close(Server);
     select(STDOUT);
     print "No Answer from Client\n";
     exit $ERRORS{"UNKNOWN"};
};
alarm($TIMEOUT);

select(Server);
$| = 1;
print Server "users\n";
my ($servanswer) = <Server>;
alarm(0);
close(Server);
select(STDOUT);

if ($servanswer =~ /^(\d*)/) {
	my ($users) = $1;
	if ($users < $warn) { 
		$answer = "Users ok - $users - connected\n";
	} elsif ($users < $crit) {
		$state = "WARNING";
		$answer = "$users users currently connected\n";
	} else {
		$state = "CRITICAL";
		$answer = "$users users currently connected\n";
	}
			
} else {
	$state = "UNKNOWN";
	$answer = "Number of users unknown!\n";
}

print $answer;
exit $ERRORS{$state};

sub usage {
	print "Minimum arguments not supplied!\n";
        print "\n";
        print "Perl Check Users plugin for NetSaint\n";
        print "Copyright (c) 1999 Charlie Cook & Nick Reinking\n";
        print "\n";
        print "Usage: $0 <host> [<warn> [<crit> [<port>]]]\n";
        print "\n";
	print "<warn> = Number of users at which a warning message will be generated.\n	Defaults to 15.\n";
	print "<crit> = Number of users at which a critical message will be generated.\n	Defaults to warn+20.\n";
	print "<port> = Port that the status daemon is running on <host>.\n	Defaults to 1040.\n";
	exit $ERRORS{"UNKNOWN"};
}
