#
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
#
# This script is released under the GNU GPLv2
#

if (description)
{
script_id(24873);
script_version("$Revision: 1.2 $");

script_bugtraq_id(23085);
script_cve_id("CVE-2007-1560");

desc["english"] = "
Synopsis :

The remote proxy server is vulnerable to a denial of service 
vulnerability.

Description :

A vulnerability in TRACE request processing has been reported in Squid,
which can be exploited by malicious people to cause a denial of service.

See also :

http://www.squid-cache.org/Advisories/SQUID-2007_1.txt

Solution : 

Upgrade to squid 2.6.STABLE12 or newer.

Risk factor :

Low / CVSS Base Score : 2.3
(AV:R/AC:L/Au:NR/C:N/I:N/A:P/B:N)";
script_description(english:desc["english"]);

script_name(english:"Squid < 2.6.STABLE12");
summary["english"] = "Determines squid version";
script_summary(english:summary["english"]);

script_category(ACT_GATHER_INFO);
script_copyright(english:"This script is Copyright (C) 2007 David Maciejak");
family["english"] = "Denial of Service";
script_family(english:family["english"]);

script_dependencies("proxy_use.nasl");
script_require_ports("Services/http_proxy",3128, 8080);
exit(0);
}

include("global_settings.inc");
include("http_func.inc");
include("http_keepalive.inc");

# nb: only run the plugin if we're being paranoid to avoid false-positives,
#     which might arise because the software is open-source.
if (report_paranoia < 2) exit(0);

port = get_kb_item("Services/http_proxy");
if(!port)port = 3128;
if(!get_port_state(port))port = 8080;

if(get_port_state(port))
{
 res = http_get_cache(item:"/", port:port);
 if(res && egrep(pattern:"[Ss]quid/2\.([0-5]\.|6\.STABLE([0-9][^0-9]|1[01][^0-9]))", string:res))
   security_note(port);
}
