#TRUSTED 619aef21d6e831a4d2aa14b16ef7a5a370bcdb4450f5f6f643f9973180e99c7893171904d555d4561675b09670a805f648f7398aa8a52b123a2bd321beacd2bbcbb188e628793d0d86b684c48ce7343e5f15f9b5d90b98146670198a561031172a2a8f079732105c0612230b4c549877717ffe3bbe8a7408b976510873322b03bfeb8e62b071b123d54645c1fcf06a95d8524937ea4afb15f4d01f778eedb7df545afc968d1fb64d3997040e29a3775fccbad6028a51153afbeaace1fd826176a85020e81f5628ec9aee830c2ccf59f2c2596f2ce51a0aa9bdfc269fd315be64c598e649b120a2cf382aa2307d4ca4761680e18c9d678bcd59e56d1e881a5633018a406275df7d835b73ff01bc8f4cd07a31e874ad06f90fb939328c197eb5e282d85207ff7f842f756a59643418cac73a8abc3eae269ae2e15745ffcab69140deb7b7bd446247b0c4190593f534f9d230392ec29af713e87fcdb8e7f4e929e059cd3e86e8d9150b6c4ba609de09f14bf5cb6017d1ab1605db7bb6e42e9889eade9a19ef100757d40b183383508a8165c1e7612b5ede0c74ee0030fe304a0f116265404fe83a18153d796e818407160cf467a2ea0ce4e45a3aefe7764bb9b62eb0e4c41b93c87899ddd4c9b5b5841bcbc07fdf45bd305b8ba14636780d57495f0321289ae208d0dfbd5f537f138c0030e24c3607bc67d84978da32a3347e3958
#
# This script was written by Michel Arboi <arboi@alussinan.org>
#
# GPL
#

if (! defined_func("script_get_preference_file_location")) exit(0);
if (! find_in_path("hydra")) exit(0);


if(description)
{
 script_id(15885);
 script_version ("1.3");
 name["english"] = "Hydra: SMTP AUTH";
 script_name(english:name["english"]);
 
 desc["english"] = "
This plugin runs Hydra to find SMTP AUTH accounts & passwords by brute force.

See the section 'plugins options' to configure it
";

 script_description(english:desc["english"]);
 
 summary["english"] = "Brute force SMTP AUTH authentication with Hydra";
 script_summary(english:summary["english"]);
 
 script_category(ACT_ATTACK);
 script_timeout(0);
 script_copyright(english:"This script is Copyright (C) 2004 Michel Arboi");
 script_family(english:"Brute force attacks");
 script_require_keys("Secret/hydra/logins_file", "Secret/hydra/passwords_file");
 script_require_ports("Services/smtp", 25);
 script_dependencies("hydra_options.nasl", "smtpserver_detect.nasl");
 exit(0);
}

#
force = get_kb_item("/tmp/hydra/force_run");
if (! force)
{
throrough = get_kb_item("global_settings/thorough_tests");
if ("yes" >!< throrough) exit(0);
}

logins = get_kb_item("Secret/hydra/logins_file");
if (logins == NULL) exit(0);

port = get_kb_item("Services/smtp");
if (! port) exit(0); # port = 25;
if (! get_port_state(port)) exit(0);
# NB: Hydra will exit if SMTP AUTH is not enabled

# Check that the MTA is up & running
soc = open_sock_tcp(port);
if (!soc) exit(0);
r = recv_line(socket: soc, length: 1024);
close(soc);
if (r !~ '^2[0-9][0-9] ') exit(0);
# Here we could send a EHLO & check that AUTH is supported...

timeout = get_kb_item("/tmp/hydra/timeout"); timeout = int(timeout);
tasks = get_kb_item("/tmp/hydra/tasks"); task = int(tasks);

empty = get_kb_item("/tmp/hydra/empty_password");
login_pass = get_kb_item("/tmp/hydra/login_password");
exit_asap = get_kb_item("/tmp/hydra/exit_ASAP");
tr = get_kb_item("Transports/TCP/"+port);

i = 0;
argv[i++] = "hydra";
argv[i++] = "-s"; argv[i++] = port;
argv[i++] = "-L"; argv[i++] = logins;
s = "";
if (empty) s = "n";
if (login_pass) s+= "s";
if (s)
{
  argv[i++] = "-e"; argv[i++] = s;
}
passwd = get_kb_item("Secret/hydra/passwords_file");
if (passwd != NULL)
{
 argv[i++] = "-P"; argv[i++] = passwd;
} else if (!s)
 exit(0);

if (exit_asap) argv[i++] = "-f";
if (tr >= ENCAPS_SSLv2) argv[i++] = "-S";

if (timeout > 0)
{
  argv[i++] = "-w";
  argv[i++] = timeout;
}
if (tasks > 0)
{
  argv[i++] = "-t";
  argv[i++] = tasks;
}

argv[i++] = get_host_ip();
argv[i++] = "smtp-auth";

report = "";
results = pread(cmd: "hydra", argv: argv, nice: 5);
foreach line (split(results))
{
  v = eregmatch(string: line, pattern: 'host:.*login: *(.*) password: *(.*)$');
  if (! isnull(v))
  {
    l = chomp(v[1]);
    p = chomp(v[2]);
    report = strcat(report, 'login: ', l, '\tpassword: ', p, '\n');
    set_kb_item(name: 'Hydra/smtp-auth/'+port, value: l + '\t' + p);
  }
}

if (report)
  security_hole(port: port, 
    data: 'Hydra was able to break the following SMTP accounts:\n' + report);
