# This script was written by Michel Arboi <mikhail@nessus.org>
# GPL


 desc = "
Synopsis :

The welcome message on this port matches the 
banner of a known backdoor.

Description :

This is highly suspicious. This machine is probably
infected by the %BACKDOOR% backdoor. 
It may already be a 'zombi' used by crackers 
to perform distributed denial of service.

See also :

http://www.nessus.org/u?3b34d116
http://www.nessus.org/u?19420d0e

Solution : 

Patch your system and run an antivirus.

Risk factor : 

High";

if(description)
{
 script_id(18367);
 script_version ("$Revision: 1.6 $");

 script_name(english: "Detect Kibuv & other worms");
 
 script_description(english:desc);

 script_summary(english: "Detect some backdoors FTP banner (KIBUV, Agobot...)");
 script_category(ACT_GATHER_INFO); 
 
 script_copyright(english:"This script is Copyright (C) 2006 Michel Arboi");
 script_family(english: "Backdoors");
 script_dependencie("find_service1.nasl");
 # Trend says that KIBUV.B is on 7955 but I saw it on 14920 and 42260
 script_require_ports("Services/three_digits", 7955);
 exit(0);
}

#
include('misc_func.inc');

banners = make_array(
"220 StnyFtpd 0wns j0",		"KIBUV.B",
"220 fuckFtpd 0wns j0",		"KIBUV.B" , 
"220 Reptile welcomes you",	"Reptile",  
"220 Bot Server (Win32)",	"Agobot"	);

function test(port)
{
 local_var	b, txt, trojan, ban;

 if (! get_port_state(port)) return 0;

 b = get_unknown_banner(port: port);
 # KIBUV.B is already processed by ftp_kibuv_worm.nasl and agobot 
 # by find_service2 and others...
 if (! b) return 0;

 foreach ban (keys(banners))
 {
  if (match(string: b, pattern: ban+'*'))
  {
   trojan=banners[ban];
   set_kb_item(name: 'ftp/'+port+'/backdoor', value: trojan);
   set_kb_item(name: 'ftp/backdoor', value: trojan);
   txt = str_replace(string: desc, find: '%BACKDOOR%', replace: trojan);
   txt = strcat(txt, '\n\nAdditional Info :\n\nThe banner is : ', b);
   security_hole(port: port, data: txt);
   return 1;
  }
 }
 return 0;
}

 # Trend says that KIBUV.B is on 7955 but I saw it on 14920 and 42260
ports = make_service_list(7955, 'Services/three_digits', 'Services/agobot.fo', 'Services/ftp');

foreach port (ports) test(port: port);
